/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CodeActionMarkerResolution
extends WorkbenchMarkerResolution
implements IMarkerResolution {
    private final CodeAction codeAction;

    public CodeActionMarkerResolution(CodeAction codeAction) {
        this.codeAction = codeAction;
    }

    public String getDescription() {
        return this.codeAction.getTitle();
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return this.codeAction.getTitle();
    }

    public void run(IMarker marker) {
        IResource resource;
        IDocument document;
        if (this.codeAction.getEdit() != null) {
            LSPEclipseUtils.applyWorkspaceEdit(this.codeAction.getEdit());
        }
        if (this.codeAction.getCommand() != null && (document = LSPEclipseUtils.getDocument(resource = marker.getResource())) != null) {
            String languageServerId = marker.getAttribute("languageServerId", null);
            CommandExecutor.executeCommand(this.codeAction.getCommand(), document, languageServerId);
        }
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        if (markers == null) {
            return new IMarker[0];
        }
        return (IMarker[])Arrays.stream(markers).filter(marker -> {
            try {
                return this.codeAction.getDiagnostics().contains(marker.getAttribute("lspDiagnostic"));
            }
            catch (CoreException e) {
                LanguageServerPlugin.logError(e);
                return false;
            }
        }).toArray(IMarker[]::new);
    }
}

