/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.project.facet.IJavaFacetInstallDataModelProperties;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;

public class JavaFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements IJavaFacetInstallDataModelProperties {
    private final JavaFacetInstallConfig installConfig;

    public JavaFacetInstallDataModelProvider() {
        this(new JavaFacetInstallConfig());
    }

    public JavaFacetInstallDataModelProvider(JavaFacetInstallConfig installConfig) {
        this.installConfig = installConfig;
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJavaFacetInstallDataModelProperties.JAVA_FACET_INSTALL_CONFIG");
        propertyNames.add("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME");
        propertyNames.add("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME");
        return propertyNames;
    }

    public void init() {
        super.init();
        final IDataModel dm = this.getDataModel();
        dm.setProperty("IFacetDataModelProperties.FACET_ID", (Object)"java");
        dm.setProperty("IJavaFacetInstallDataModelProperties.JAVA_FACET_INSTALL_CONFIG", (Object)this.installConfig);
        String sourceFolderName = null;
        if (!this.installConfig.getSourceFolders().isEmpty()) {
            sourceFolderName = ((IPath)this.installConfig.getSourceFolders().get(0)).toPortableString();
        }
        dm.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", sourceFolderName);
        String defaultOutputFolderName = null;
        if (this.installConfig.getDefaultOutputFolder() != null) {
            defaultOutputFolderName = this.installConfig.getDefaultOutputFolder().toPortableString();
        }
        dm.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", defaultOutputFolderName);
        IEventListener<JavaFacetInstallConfig.ChangeEvent> listener = new IEventListener<JavaFacetInstallConfig.ChangeEvent>(){

            public void handleEvent(JavaFacetInstallConfig.ChangeEvent event) {
                if (event.getType() == JavaFacetInstallConfig.ChangeEvent.Type.SOURCE_FOLDERS_CHANGED) {
                    String val = null;
                    if (JavaFacetInstallDataModelProvider.this.installConfig.getSourceFolders().size() > 0) {
                        val = ((IPath)JavaFacetInstallDataModelProvider.this.installConfig.getSourceFolders().get(0)).toPortableString();
                    }
                    dm.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", val);
                } else if (event.getType() == JavaFacetInstallConfig.ChangeEvent.Type.DEFAULT_OUTPUT_FOLDER_CHANGED) {
                    String val = JavaFacetInstallDataModelProvider.this.installConfig.getDefaultOutputFolder().toPortableString();
                    dm.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)val);
                }
            }
        };
        this.installConfig.addListener((IEventListener)listener, new JavaFacetInstallConfig.ChangeEvent.Type[0]);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME")) {
            List<Object> sourceFolders = propertyValue == null ? Collections.emptyList() : Collections.singletonList(new Path((String)propertyValue));
            this.installConfig.setSourceFolders(sourceFolders);
            return true;
        }
        if (propertyName.equals("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME")) {
            this.installConfig.setDefaultOutputFolder((IPath)new Path((String)propertyValue));
            return true;
        }
        if (propertyName.equals("IJavaFacetInstallDataModelProperties.JAVA_FACET_INSTALL_CONFIG")) {
            return false;
        }
        return super.propertySet(propertyName, propertyValue);
    }
}

