/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMNamespaceHelper {
    protected static String getURIForPrefix(Element element, String prefix) {
        String result = null;
        String nsAttrName = null;
        nsAttrName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
        Node node = element;
        while (node != null) {
            if (node.getNodeType() != 1) break;
            Element theElement = node;
            Attr attr = theElement.getAttributeNode(nsAttrName);
            if (attr != null) {
                result = attr.getValue();
            }
            node = node.getParentNode();
        }
        if (result == null) {
            NamespaceTable table = new NamespaceTable(element.getOwnerDocument());
            result = table.getURIForPrefix(prefix);
        }
        return result;
    }

    public static String getNamespaceURI(Node node) {
        String result = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String prefix = element.getPrefix();
            result = DOMNamespaceHelper.getURIForPrefix(element, prefix);
        } else if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String prefix = attr.getPrefix();
            result = DOMNamespaceHelper.getURIForPrefix(attr.getOwnerElement(), prefix);
        }
        return result;
    }

    public static String computePrefix(CMNode cmNode, Node parentNode) {
        String result = null;
        Node node = parentNode;
        while (node != null) {
            if (node.getNodeType() == 1 && (result = DOMNamespaceHelper.getPrefix(node.getNodeName())) != null) break;
            node = node.getParentNode();
        }
        return result;
    }

    public static String getPrefix(String name) {
        String prefix = null;
        int index = name.indexOf(":");
        if (index != -1) {
            prefix = name.substring(0, index);
        }
        return prefix;
    }

    public static String getUnprefixedName(String name) {
        int index = name.indexOf(":");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static String computeName(CMNode cmNode, Node parent, String prefix) {
        return DOMNamespaceHelper.computeName(cmNode, parent, prefix, null);
    }

    public static String computeName(CMNode cmNode, Node parent, String prefix, NamespaceTable namespaceTable) {
        String qualification;
        String result = cmNode.getNodeName();
        if (DOMNamespaceHelper.getPrefix(result) == null && (qualification = (String)cmNode.getProperty("http://org.eclipse.wst/cm/properties/nsPrefixQualification")) != null && qualification.equals("qualified")) {
            String namespaceURI;
            CMDocument cmDocument;
            if (prefix == null && (cmDocument = (CMDocument)cmNode.getProperty("CMDocument")) != null && (namespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI")) != null) {
                if (namespaceTable == null) {
                    Document document = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
                    namespaceTable = new NamespaceTable(document);
                    if (parent instanceof Element) {
                        namespaceTable.addElementLineage((Element)parent);
                    }
                }
                prefix = namespaceTable.getPrefixForURI(namespaceURI);
            }
            if (prefix != null && prefix.length() > 0) {
                result = String.valueOf(prefix) + ":" + result;
            }
        }
        return result;
    }

    public static String[] getURIQualifiedNameComponents(String uriQualifiedName) {
        String[] result = new String[2];
        int firstIndex = uriQualifiedName.indexOf("[");
        int lastIndex = uriQualifiedName.indexOf("]");
        if (firstIndex != -1 && lastIndex > firstIndex) {
            result[0] = uriQualifiedName.substring(firstIndex + 1, lastIndex);
            result[1] = uriQualifiedName.substring(lastIndex + 1);
        } else {
            result[1] = uriQualifiedName;
        }
        return result;
    }
}

