/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpql;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaManagedType;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaTypeDeclaration;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaTypeRepository;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IMappingType;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JpaMapping
implements IMapping {
    private final AttributeMapping mapping;
    private IMappingType mappingType;
    private final JpaManagedType parent;
    private IType type;
    private ITypeDeclaration typeDeclaration;

    JpaMapping(JpaManagedType parent, AttributeMapping mapping) {
        this.parent = parent;
        this.mapping = mapping;
    }

    private ITypeDeclaration[] buildGenericTypeDeclarations() {
        JavaPersistentAttribute javaPersistentAttribute = this.mapping.getPersistentAttribute().getJavaPersistentAttribute();
        JavaResourcePersistentAttribute resource = javaPersistentAttribute.getResourcePersistentAttribute();
        ArrayList declarations = CollectionTools.list(this.buildGenericTypeDeclarations(resource));
        return declarations.toArray(new ITypeDeclaration[declarations.size()]);
    }

    private Iterator<ITypeDeclaration> buildGenericTypeDeclarations(JavaResourcePersistentAttribute resource) {
        return new TransformationIterator<String, ITypeDeclaration>(resource.typeTypeArgumentNames()){

            protected ITypeDeclaration transform(String next) {
                return JpaMapping.this.getTypeRepository().getType(next).getTypeDeclaration();
            }
        };
    }

    private ITypeDeclaration buildTypeDeclaration() {
        PersistentAttribute property = this.mapping.getPersistentAttribute();
        boolean array = property.getTypeName().endsWith("[]");
        int dimensionality = 0;
        if (array) {
            dimensionality = this.getType().getTypeDeclaration().getDimensionality();
        }
        return new JpaTypeDeclaration(this.getType(), this.buildGenericTypeDeclarations(), dimensionality);
    }

    public int compareTo(IMapping mapping) {
        return this.getName().compareTo(mapping.getName());
    }

    public IMappingType getMappingType() {
        if (this.mappingType == null) {
            this.getTypeDeclaration();
            this.mappingType = this.mappingType();
        }
        return this.mappingType;
    }

    public String getName() {
        return this.mapping.getName();
    }

    public IManagedType getParent() {
        return this.parent;
    }

    public IType getType() {
        if (this.type == null) {
            PersistentAttribute property = this.mapping.getPersistentAttribute();
            this.type = this.getTypeRepository().getType(property.getTypeName());
        }
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    private JpaTypeRepository getTypeRepository() {
        return this.parent.getProvider().getTypeRepository();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        JavaResourcePersistentAttribute attribute = this.mapping.getPersistentAttribute().getJavaPersistentAttribute().getResourcePersistentAttribute();
        return attribute.getAnnotation(annotationType.getName()) != null;
    }

    private IMappingType mappingType() {
        String type = this.mapping.getKey();
        if (type == "basic") {
            return IMappingType.BASIC;
        }
        if (type == "embedded") {
            return IMappingType.EMBEDDED;
        }
        if (type == "embeddedId") {
            return IMappingType.EMBEDDED_ID;
        }
        if (type == "id") {
            return IMappingType.ID;
        }
        if (type == "manyToMany") {
            return IMappingType.MANY_TO_MANY;
        }
        if (type == "oneToMany") {
            return IMappingType.ONE_TO_MANY;
        }
        if (type == "manyToOne") {
            return IMappingType.MANY_TO_ONE;
        }
        if (type == "oneToOne") {
            return IMappingType.ONE_TO_ONE;
        }
        if (type == "version") {
            return IMappingType.VERSION;
        }
        if (type == "elementCollection") {
            return IMappingType.ELEMENT_COLLECTION;
        }
        return IMappingType.TRANSIENT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn((Object)this, (StringBuilder)sb);
        sb.append(", name=");
        sb.append(this.getName());
        sb.append(", mappingType=");
        sb.append(this.getMappingType());
        return sb.toString();
    }
}

