/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmCascade;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappingRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmCascade;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlRelationshipMapping;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmRelationshipMapping<X extends AbstractXmlRelationshipMapping>
extends AbstractOrmAttributeMapping<X>
implements OrmRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected final OrmMappingRelationship relationship;
    protected final OrmCascade cascade;
    protected FetchType specifiedFetch;
    protected FetchType defaultFetch;

    protected AbstractOrmRelationshipMapping(OrmPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
        this.specifiedTargetEntity = ((AbstractXmlRelationshipMapping)xmlMapping).getTargetEntity();
        this.relationship = this.buildRelationship();
        this.cascade = this.buildCascade();
        this.specifiedFetch = this.buildSpecifiedFetch();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTargetEntity_(((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).getTargetEntity());
        this.relationship.synchronizeWithResourceModel();
        this.cascade.synchronizeWithResourceModel();
        this.setSpecifiedFetch_(this.buildSpecifiedFetch());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.relationship.update();
        this.cascade.update();
        this.setDefaultFetch(this.buildDefaultFetch());
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String entity) {
        this.setSpecifiedTargetEntity_(entity);
        ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).setTargetEntity(entity);
    }

    protected void setSpecifiedTargetEntity_(String entity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = entity;
        this.firePropertyChanged("specifiedTargetEntity", old, entity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String entity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = entity;
        this.firePropertyChanged("defaultTargetEntity", old, entity);
    }

    protected String buildDefaultTargetEntity() {
        return this.getJavaPersistentAttribute() == null ? null : this.getJavaTargetType();
    }

    protected abstract String getJavaTargetType();

    @Override
    public Entity getResolvedTargetEntity() {
        TypeMapping typeMapping = this.getResolvedTargetTypeMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    protected TypeMapping getResolvedTargetTypeMapping() {
        PersistentType resolvedTargetType = this.getResolvedTargetType();
        return resolvedTargetType == null ? null : resolvedTargetType.getMapping();
    }

    public PersistentType getResolvedTargetType() {
        return this.resolvePersistentType(this.getTargetEntity());
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public OrmMappingRelationship getRelationship() {
        return this.relationship;
    }

    protected abstract OrmMappingRelationship buildRelationship();

    @Override
    public OrmCascade getCascade() {
        return this.cascade;
    }

    protected OrmCascade buildCascade() {
        return new GenericOrmCascade(this);
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.defaultFetch;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        this.setSpecifiedFetch_(fetch);
        ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).setFetch(FetchType.toOrmResourceModel(fetch));
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildSpecifiedFetch() {
        return FetchType.fromOrmResourceModel(((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).getFetch());
    }

    @Override
    public FetchType getDefaultFetch() {
        return this.defaultFetch;
    }

    protected void setDefaultFetch(FetchType fetch) {
        FetchType old = this.defaultFetch;
        this.defaultFetch = fetch;
        this.firePropertyChanged("defaultFetch", (Object)old, (Object)fetch);
    }

    protected abstract FetchType buildDefaultFetch();

    @Override
    public boolean isRelationshipOwner() {
        return this.relationship.isOwner();
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return mapping.isRelationshipOwner() && this.relationship.isOwnedBy((RelationshipMapping)mapping);
    }

    @Override
    public RelationshipMapping getRelationshipOwner() {
        Entity entity = this.getResolvedTargetEntity();
        if (entity == null) {
            return null;
        }
        for (ReadOnlyPersistentAttribute attribute : CollectionTools.iterable(entity.getPersistentType().allAttributes())) {
            AttributeMapping mapping = attribute.getMapping();
            if (!this.isOwnedBy(mapping)) continue;
            return (RelationshipMapping)mapping;
        }
        return null;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return this.relationship.isOverridable();
    }

    @Override
    protected void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        super.initializeFromOrmRelationshipMapping(oldMapping);
        this.setSpecifiedTargetEntity(oldMapping.getSpecifiedTargetEntity());
        this.setSpecifiedFetch(oldMapping.getSpecifiedFetch());
        oldMapping.getRelationship().initializeOn(this.relationship);
        this.cascade.initializeFrom(oldMapping.getCascade());
    }

    @Override
    public Iterator<String> allTargetEntityAttributeNames() {
        return new CompositeIterator(this.allTargetEntityAttributeNamesLists());
    }

    protected Iterator<Iterator<String>> allTargetEntityAttributeNamesLists() {
        return new TransformationIterator(this.allTargetEntityAttributeMappings(), AttributeMappingTools.ALL_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterator<AttributeMapping> allTargetEntityAttributeMappings() {
        Entity entity = this.getResolvedTargetEntity();
        return entity != null ? entity.allAttributeMappings() : EmptyIterator.instance();
    }

    protected String getTargetEntityIdAttributeName() {
        PersistentAttribute attribute = this.getTargetEntityIdAttribute();
        return attribute == null ? null : attribute.getName();
    }

    protected PersistentAttribute getTargetEntityIdAttribute() {
        Entity entity = this.getResolvedTargetEntity();
        return entity == null ? null : entity.getIdAttribute();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createTargetEntityRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createTargetEntityRenameTypeEdits(IType originalType, String newName) {
        PersistentType targetType;
        if (this.specifiedTargetEntity != null && (targetType = this.getResolvedTargetType()) != null && targetType.isFor(originalType.getFullyQualifiedName('.'))) {
            return new SingleElementIterable((Object)this.createTargetEntityRenameTypeEdit(originalType, newName));
        }
        return EmptyIterable.instance();
    }

    protected ReplaceEdit createTargetEntityRenameTypeEdit(IType originalType, String newName) {
        return ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).createRenameTargetEntityEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createTargetEntityMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createTargetEntityMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        PersistentType targetType;
        if (this.specifiedTargetEntity != null && (targetType = this.getResolvedTargetType()) != null && targetType.isFor(originalType.getFullyQualifiedName('.'))) {
            return new SingleElementIterable((Object)this.createTargetEntityRenamePackageEdit(newPackage.getElementName()));
        }
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createTargetEntityRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createTargetEntityRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        PersistentType targetType;
        if (this.specifiedTargetEntity != null && (targetType = this.getResolvedTargetType()) != null && targetType.isIn(originalPackage)) {
            return new SingleElementIterable((Object)this.createTargetEntityRenamePackageEdit(newName));
        }
        return EmptyIterable.instance();
    }

    protected ReplaceEdit createTargetEntityRenamePackageEdit(String newName) {
        return ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).createRenameTargetEntityPackageEdit(newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTargetEntity(messages);
        this.relationship.validate(messages, reporter);
    }

    protected void validateTargetEntity(List<IMessage> messages) {
        if (this.getTargetEntity() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_NOT_DEFINED", new String[]{this.name}, this, this.getValidationTextRange()));
            return;
        }
        if (this.getResolvedTargetEntity() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getTargetEntity(), this.name}, this, this.getTargetEntityTextRange()));
        }
    }

    protected TextRange getTargetEntityTextRange() {
        return this.getValidationTextRange(((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).getTargetEntityTextRange());
    }

    @Override
    public String getMetamodelTypeName() {
        PersistentType resolvedTargetType = this.getResolvedTargetType();
        if (resolvedTargetType == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        String targetTypeName = resolvedTargetType.getName();
        return targetTypeName != null ? targetTypeName : MetamodelField.DEFAULT_TYPE_NAME;
    }
}

