/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpql;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaManagedType;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaManagedTypeProvider;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaQuery;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JpaEntity
extends JpaManagedType
implements IEntity {
    private Map<String, IQuery> queries;

    JpaEntity(JpaManagedTypeProvider provider, Entity entity) {
        super(provider, entity);
    }

    public void accept(IManagedTypeVisitor visitor) {
        visitor.visit((IEntity)this);
    }

    final IQuery buildQuery(JpaManagedTypeProvider provider, NamedQuery namedQuery) {
        return new JpaQuery(provider, namedQuery);
    }

    @Override
    Entity getManagedType() {
        return (Entity)super.getManagedType();
    }

    public final String getName() {
        return this.getManagedType().getName();
    }

    public IQuery getNamedQuery(String queryName) {
        this.initializeQueries();
        return this.queries.get(queryName);
    }

    private void initializeQueries() {
        if (this.queries == null) {
            this.queries = new HashMap<String, IQuery>();
            this.initializeQueries(this.queries);
        }
    }

    void initializeQueries(Map<String, IQuery> queries) {
        JpaManagedTypeProvider provider = this.getProvider();
        ListIterator<NamedQuery> iter = this.namedQueries();
        while (iter.hasNext()) {
            NamedQuery namedQuery = iter.next();
            queries.put(namedQuery.getName(), this.buildQuery(provider, namedQuery));
        }
    }

    private ListIterator<NamedQuery> namedQueries() {
        return this.getManagedType().getQueryContainer().namedQueries();
    }

    public String toString() {
        return this.getName();
    }
}

