/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.AbstractNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.NodeListImpl;
import org.eclipse.wst.xml.core.internal.document.ReadOnlyController;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.document.UserData;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
extends AbstractNotifier
implements Node,
IDOMNode {
    private static final NodeList EMPTY_NODE_LIST = new NodeListImpl();
    private static final short DOCUMENT_POSITION_PRECEDING = 2;
    private static final short DOCUMENT_POSITION_FOLLOWING = 4;
    private static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    private boolean fDataEditable = true;
    private IStructuredDocumentRegion flatNode = null;
    private NodeImpl nextSibling = null;
    private DocumentImpl ownerDocument = null;
    private NodeImpl parentNode = null;
    private NodeImpl previousSibling = null;
    static final String EMPTY_STRING = "";

    protected NodeImpl() {
    }

    protected NodeImpl(NodeImpl that) {
        if (that != null) {
            this.ownerDocument = that.ownerDocument;
        }
    }

    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(3, DOMMessages.HIERARCHY_REQUEST_ERR);
    }

    public boolean contains(int offset) {
        return offset >= this.getStartOffset() && offset < this.getEndOffset();
    }

    protected String createDOMExceptionMessage(short s, String tagName) {
        String result = null;
        result = String.valueOf(this.lookupMessage(s)) + " " + tagName;
        return result;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    protected String getCharValue(String name) {
        DocumentImpl document = (DocumentImpl)this.getOwnerDocument();
        if (document == null) {
            return null;
        }
        return document.getCharValue(name);
    }

    public NodeList getChildNodes() {
        return EMPTY_NODE_LIST;
    }

    public Node getCommonAncestor(Node node) {
        if (node == null) {
            return null;
        }
        Node na = node;
        while (na != null) {
            Node ta = this;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    public Document getContainerDocument() {
        Node parent = null;
        Node node = this;
        while (node != null) {
            if (node.getNodeType() == 9) {
                return (Document)node;
            }
            parent = node.getParentNode();
            if (parent == node) break;
            node = parent;
        }
        return null;
    }

    public int getEndOffset() {
        Node node = this;
        block0: while (node != null) {
            ElementImpl element;
            IStructuredDocumentRegion endStructuredDocumentRegion;
            if (node.getNodeType() == 1 && (endStructuredDocumentRegion = (element = (ElementImpl)node).getEndStructuredDocumentRegion()) != null) {
                return endStructuredDocumentRegion.getEnd();
            }
            Node last = node.getLastChild();
            if (last != null) {
                node = last;
                continue;
            }
            IStructuredDocumentRegion lastStructuredDocumentRegion = ((NodeImpl)node).getStructuredDocumentRegion();
            if (lastStructuredDocumentRegion != null) {
                return lastStructuredDocumentRegion.getEnd();
            }
            Node prev = node.getPreviousSibling();
            if (prev != null) {
                node = prev;
                continue;
            }
            Node parent = node.getParentNode();
            node = null;
            while (parent != null) {
                ElementImpl element2;
                IStructuredDocumentRegion startStructuredDocumentRegion;
                if (parent.getNodeType() == 1 && (startStructuredDocumentRegion = (element2 = (ElementImpl)parent).getStartStructuredDocumentRegion()) != null) {
                    return startStructuredDocumentRegion.getEnd();
                }
                Node parentPrev = parent.getPreviousSibling();
                if (parentPrev != null) {
                    node = parentPrev;
                    continue block0;
                }
                parent = parent.getParentNode();
            }
        }
        return 0;
    }

    public IStructuredDocumentRegion getEndStructuredDocumentRegion() {
        return null;
    }

    public FactoryRegistry getFactoryRegistry() {
        FactoryRegistry reg;
        IDOMModel model = this.getModel();
        if (model != null && (reg = model.getFactoryRegistry()) != null) {
            return reg;
        }
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public IStructuredDocumentRegion getFirstStructuredDocumentRegion() {
        return StructuredDocumentRegionUtil.getStructuredDocumentRegion(this.flatNode);
    }

    public int getIndex() {
        Node parent = this.getParentNode();
        if (parent == null) {
            return -1;
        }
        int index = 0;
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child == this) {
                return index;
            }
            ++index;
            child = child.getNextSibling();
        }
        return -1;
    }

    public Node getLastChild() {
        return null;
    }

    public IStructuredDocumentRegion getLastStructuredDocumentRegion() {
        return StructuredDocumentRegionUtil.getStructuredDocumentRegion(this.flatNode);
    }

    public String getLocalName() {
        return null;
    }

    public IDOMModel getModel() {
        if (this.ownerDocument == null) {
            return null;
        }
        return this.ownerDocument.getModel();
    }

    public ITextRegion getNameRegion() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    Node getNodeAt(int offset) {
        IDOMNode parent = this;
        IDOMNode child = (IDOMNode)this.getFirstChild();
        while (child != null) {
            if (child.getEndOffset() <= offset) {
                child = (IDOMNode)child.getNextSibling();
                continue;
            }
            if (child.getStartOffset() > offset) break;
            IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
            if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                return child;
            }
            parent = child;
            child = (IDOMNode)parent.getFirstChild();
        }
        return parent;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public String getSource() {
        if (this.flatNode == null) {
            return EMPTY_STRING;
        }
        return this.flatNode.getText();
    }

    public int getStartOffset() {
        if (this.flatNode != null) {
            return this.flatNode.getStart();
        }
        NodeImpl prev = (NodeImpl)this.getPreviousSibling();
        if (prev != null) {
            return prev.getEndOffset();
        }
        Node parent = this.getParentNode();
        if (parent != null && parent.getNodeType() == 1) {
            ElementImpl element = (ElementImpl)parent;
            if (element.hasStartTag()) {
                return element.getStartEndOffset();
            }
            return element.getStartOffset();
        }
        NodeImpl child = (NodeImpl)this.getFirstChild();
        while (child != null) {
            IStructuredDocumentRegion childStructuredDocumentRegion = child.getStructuredDocumentRegion();
            if (childStructuredDocumentRegion != null) {
                return childStructuredDocumentRegion.getStart();
            }
            child = (NodeImpl)child.getFirstChild();
        }
        return 0;
    }

    public IStructuredDocumentRegion getStartStructuredDocumentRegion() {
        return this.getFirstStructuredDocumentRegion();
    }

    public IStructuredDocument getStructuredDocument() {
        return this.getModel().getStructuredDocument();
    }

    IStructuredDocumentRegion getStructuredDocumentRegion() {
        return this.flatNode;
    }

    public ITextRegion getValueRegion() {
        return null;
    }

    public String getValueSource() {
        return this.getNodeValue();
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public boolean hasProperties() {
        return false;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(3, DOMMessages.HIERARCHY_REQUEST_ERR);
    }

    public boolean isChildEditable() {
        return false;
    }

    public boolean isClosed() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isDataEditable() {
        DOMModelImpl model;
        if (!this.fDataEditable && (model = (DOMModelImpl)this.getModel()) != null && model.isReparsing()) {
            return true;
        }
        return this.fDataEditable;
    }

    public boolean isSupported(String feature, String version) {
        if (this.ownerDocument == null) {
            return false;
        }
        DOMImplementation impl = this.ownerDocument.getImplementation();
        if (impl == null) {
            return false;
        }
        return impl.hasFeature(feature, version);
    }

    private String lookupMessage(short s) {
        String result = null;
        switch (s) {
            case 2: {
                result = DOMMessages.DOMSTRING_SIZE_ERR;
                break;
            }
            case 3: {
                result = DOMMessages.HIERARCHY_REQUEST_ERR;
                break;
            }
            case 1: {
                result = DOMMessages.INDEX_SIZE_ERR;
                break;
            }
            case 10: {
                result = DOMMessages.INUSE_ATTRIBUTE_ERR;
                break;
            }
            case 15: {
                result = DOMMessages.INVALID_ACCESS_ERR;
                break;
            }
            case 5: {
                result = DOMMessages.INVALID_CHARACTER_ERR;
                break;
            }
            case 13: {
                result = DOMMessages.INVALID_MODIFICATION_ERR;
                break;
            }
            case 11: {
                result = DOMMessages.INVALID_STATE_ERR;
                break;
            }
            case 14: {
                result = DOMMessages.NAMESPACE_ERR;
                break;
            }
            case 6: {
                result = DOMMessages.NO_DATA_ALLOWED_ERR;
                break;
            }
            case 7: {
                result = DOMMessages.NO_MODIFICATION_ALLOWED_ERR;
                break;
            }
            case 8: {
                result = DOMMessages.NOT_FOUND_ERR;
                break;
            }
            case 9: {
                result = DOMMessages.NOT_SUPPORTED_ERR;
                break;
            }
            case 12: {
                result = DOMMessages.SYNTAX_ERR;
                break;
            }
            case 17: {
                result = DOMMessages.TYPE_MISMATCH_ERR;
                break;
            }
            case 16: {
                result = DOMMessages.VALIDATION_ERR;
                break;
            }
            case 4: {
                result = DOMMessages.WRONG_DOCUMENT_ERR;
                break;
            }
            default: {
                result = EMPTY_STRING;
            }
        }
        return result;
    }

    public void normalize() {
        TextImpl prevText = null;
        Node child = this.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 3: {
                    if (prevText == null) {
                        prevText = (TextImpl)child;
                        break;
                    }
                    Text text = (Text)child;
                    this.removeChild(text);
                    prevText.appendText(text);
                    child = prevText;
                    break;
                }
                case 1: {
                    Element element = (Element)child;
                    element.normalize();
                    prevText = null;
                    break;
                }
                default: {
                    prevText = null;
                }
            }
            child = child.getNextSibling();
        }
    }

    protected void notifyEditableChanged() {
        DocumentImpl document = (DocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.editableChanged(this);
    }

    protected void notifyValueChanged() {
        DocumentImpl document = (DocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        this.syncDataEditableState();
        DOMModelImpl model = (DOMModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.valueChanged(this);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(8, DOMMessages.NOT_FOUND_ERR);
    }

    public void removeChildNodes() {
    }

    public DocumentFragment removeChildNodes(Node firstChild, Node lastChild) {
        return null;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(3, DOMMessages.HIERARCHY_REQUEST_ERR);
    }

    void resetStructuredDocumentRegions() {
        NodeImpl child = (NodeImpl)this.getFirstChild();
        while (child != null) {
            child.resetStructuredDocumentRegions();
            child = (NodeImpl)child.getNextSibling();
        }
        this.flatNode = null;
    }

    public void setChildEditable(boolean editable) {
    }

    public void setDataEditable(boolean editable) {
        if (this.fDataEditable == editable) {
            return;
        }
        ReadOnlyController roc = ReadOnlyController.getInstance();
        if (editable) {
            roc.unlockData(this);
        } else {
            roc.lockData(this);
        }
        this.fDataEditable = editable;
        this.notifyEditableChanged();
    }

    public void setEditable(boolean editable, boolean deep) {
        if (deep) {
            IDOMNode node = (IDOMNode)this.getFirstChild();
            while (node != null) {
                node.setEditable(editable, deep);
                node = (IDOMNode)node.getNextSibling();
            }
        }
        this.setChildEditable(editable);
        this.setDataEditable(editable);
    }

    protected void setNextSibling(Node nextSibling) {
        this.nextSibling = (NodeImpl)nextSibling;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    protected void setOwnerDocument(Document ownerDocument) {
        this.ownerDocument = (DocumentImpl)ownerDocument;
    }

    protected void setOwnerDocument(Document ownerDocument, boolean deep) {
        this.ownerDocument = (DocumentImpl)ownerDocument;
        if (deep) {
            NodeImpl child = (NodeImpl)this.getFirstChild();
            while (child != null) {
                child.setOwnerDocument(ownerDocument, deep);
                child = (NodeImpl)child.getNextSibling();
            }
        }
    }

    protected void setParentNode(Node parentNode) {
        this.parentNode = (NodeImpl)parentNode;
    }

    public void setPrefix(String prefix) throws DOMException {
    }

    protected void setPreviousSibling(Node previousSibling) {
        this.previousSibling = (NodeImpl)previousSibling;
    }

    public void setSource(String source) throws InvalidCharacterException {
    }

    void setStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        this.flatNode = flatNode;
    }

    public void setValueSource(String source) {
        this.setNodeValue(source);
    }

    protected void syncDataEditableState() {
        ReadOnlyController roc = ReadOnlyController.getInstance();
        if (this.fDataEditable) {
            roc.unlockData(this);
        } else {
            roc.lockData(this);
        }
    }

    public String toString() {
        return this.getNodeName();
    }

    public int getLength() {
        int end;
        int result = -1;
        int start = this.getStartOffset();
        if (start >= 0 && (end = this.getEndOffset()) >= 0 && (result = end - start) < -1) {
            result = -1;
        }
        return result;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        if (!(other instanceof IDOMNode)) {
            throw new DOMException(9, DOMMessages.NOT_SUPPORTED_ERR);
        }
        int nodeStart = this.getStartOffset();
        int otherStart = ((IDOMNode)other).getStartOffset();
        if (otherStart > nodeStart) {
            return 4;
        }
        if (otherStart < nodeStart) {
            return 2;
        }
        return 32;
    }

    public String getBaseURI() {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public Object getFeature(String feature, String version) {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public String getTextContent() throws DOMException {
        switch (this.getNodeType()) {
            case 9: 
            case 10: 
            case 12: {
                return null;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.getNodeValue();
            }
        }
        if (this.hasChildNodes()) {
            StringBuffer builder = new StringBuffer();
            Node child = this.getFirstChild();
            while (child != null) {
                short nodeType = child.getNodeType();
                if (nodeType == 8 || nodeType == 7) {
                    child = child.getNextSibling();
                    continue;
                }
                String text = ((IDOMNode)child).getTextContent();
                if (text != null) {
                    builder.append(text);
                }
                child = child.getNextSibling();
            }
            return builder.toString();
        }
        return EMPTY_STRING;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public boolean isEqualNode(Node arg) {
        return this.equals(arg);
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public String lookupNamespaceURI(String prefix) {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public String lookupPrefix(String namespaceURI) {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public boolean isId() {
        throw new DOMException(9, "Not implemented in this version.");
    }

    public Object getUserData(String key) {
        UserDataAndHandler userDataAndHandler;
        if (key == null) {
            return null;
        }
        Map userDataTable = UserData.getInstance().getUserDataTable(this);
        if (userDataTable != null && (userDataAndHandler = (UserDataAndHandler)userDataTable.get(key)) != null) {
            return userDataAndHandler.getData();
        }
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        UserDataAndHandler previousDataAndHandler = null;
        if (key == null) {
            return null;
        }
        Hashtable<String, UserDataAndHandler> userDataTable = UserData.getInstance().getUserDataTable(this);
        if (data == null) {
            if (userDataTable == null) {
                return null;
            }
            previousDataAndHandler = (UserDataAndHandler)userDataTable.get(key);
            if (previousDataAndHandler != null) {
                userDataTable.remove(key);
                return previousDataAndHandler.getData();
            }
            return null;
        }
        if (userDataTable == null) {
            userDataTable = new Hashtable<String, UserDataAndHandler>();
            UserDataAndHandler userDataAndHandler = new UserDataAndHandler(data, handler);
            userDataTable.put(key, userDataAndHandler);
            return null;
        }
        UserDataAndHandler userDataAndHandler = new UserDataAndHandler(data, handler);
        previousDataAndHandler = userDataTable.put(key, userDataAndHandler);
        if (previousDataAndHandler != null) {
            return previousDataAndHandler.getData();
        }
        return null;
    }

    protected void notifyUserDataHandlers(short operation, Node destination) {
        if (operation != 5 & operation != 1 & operation != 3 & operation != 2 & operation != 4) {
            return;
        }
        Map userDataTable = UserData.getInstance().getUserDataTable(this);
        if (userDataTable != null) {
            Iterator entries = userDataTable.entrySet().iterator();
            while (entries.hasNext()) {
                UserDataHandler dataHandler;
                Map.Entry entry = entries.next();
                String key = entry.getKey().toString();
                UserDataAndHandler dataAndHandler = (UserDataAndHandler)entry.getValue();
                if (dataAndHandler == null || (dataHandler = dataAndHandler.getHandler()) == null) continue;
                dataHandler.handle(operation, key, dataAndHandler.getData(), this, destination);
            }
        }
    }

    protected static class UserDataAndHandler
    implements Serializable {
        private static final long serialVersionUID = 4860521237315444841L;
        private Object data;
        private UserDataHandler handler;

        public UserDataAndHandler(Object data, UserDataHandler handler) {
            this.data = data;
            this.handler = handler;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public UserDataHandler getHandler() {
            return this.handler;
        }

        public void setHandler(UserDataHandler handler) {
            this.handler = handler;
        }
    }
}

