/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.validation;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.IResourcePart;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationPreferences;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaValidator
extends AbstractValidator
implements IValidator {
    public void validate(IValidationContext context, IReporter reporter) {
        this.validate(reporter, this.project(context));
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        IProject project = resource.getProject();
        this.clearMarkers(project);
        result.setSuspendValidation(project);
        this.validate(reporter, project);
        return result;
    }

    private void clearMarkers(IProject project) {
        try {
            this.clearMarkers_(project);
        }
        catch (CoreException ce) {
            JptJpaCorePlugin.log(ce);
        }
    }

    private void clearMarkers_(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.jpt.jpa.core.jpaProblemMarker", true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    private void validate(IReporter reporter, IProject project) {
        for (IMessage message : this.getValidationMessages(reporter, project)) {
            if (JpaValidationPreferences.isProblemIgnored(project, message.getId())) continue;
            reporter.addMessage((IValidator)this, this.adjustMessage(message));
        }
    }

    private IProject project(IValidationContext context) {
        return ((IProjectValidationContext)context).getProject();
    }

    private Iterable<IMessage> getValidationMessages(IReporter reporter, IProject project) {
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject(project);
        if (jpaProject != null) {
            return jpaProject.getValidationMessages(reporter);
        }
        return new SingleElementIterable((Object)DefaultJpaValidationMessages.buildMessage(1, "NO_JPA_PROJECT", project));
    }

    private IMessage adjustMessage(IMessage message) {
        IAdaptable targetObject = (IAdaptable)message.getTargetObject();
        IResource targetResource = ((IResourcePart)targetObject.getAdapter(IResourcePart.class)).getResource();
        message.setTargetObject((Object)targetResource);
        if (message.getLineNumber() == 0) {
            message.setAttribute("location", (Object)" ");
        }
        return message;
    }
}

