/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.JoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.JoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;

public class GenericOrmVirtualOverrideJoinTableRelationshipStrategy2_0
extends AbstractOrmXmlContextNode
implements OrmVirtualJoinTableRelationshipStrategy {
    protected OrmVirtualJoinTable joinTable;

    public GenericOrmVirtualOverrideJoinTableRelationshipStrategy2_0(OrmVirtualJoinTableRelationship parent) {
        super(parent);
    }

    public void update() {
        super.update();
        this.updateJoinTable();
    }

    public OrmVirtualJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable(OrmVirtualJoinTable joinTable) {
        OrmVirtualJoinTable old = this.joinTable;
        this.joinTable = joinTable;
        this.firePropertyChanged("joinTable", old, joinTable);
    }

    protected void updateJoinTable() {
        JoinTable overriddenJoinTable = this.getOverriddenJoinTable();
        if (overriddenJoinTable == null) {
            if (this.joinTable != null) {
                this.setJoinTable(null);
            }
        } else if (this.joinTable != null && this.joinTable.getOverriddenTable() == overriddenJoinTable) {
            this.joinTable.update();
        } else {
            this.setJoinTable(this.buildJoinTable(overriddenJoinTable));
        }
    }

    protected JoinTable getOverriddenJoinTable() {
        JoinTableRelationshipStrategy overriddenStrategy = this.getOverriddenStrategy();
        return overriddenStrategy == null ? null : overriddenStrategy.getJoinTable();
    }

    protected OrmVirtualJoinTable buildJoinTable(JoinTable overriddenJoinTable) {
        return this.getContextNodeFactory().buildOrmVirtualJoinTable(this, overriddenJoinTable);
    }

    public OrmVirtualJoinTableRelationship getParent() {
        return (OrmVirtualJoinTableRelationship)super.getParent();
    }

    public OrmVirtualJoinTableRelationship getRelationship() {
        return this.getParent();
    }

    protected JoinTableRelationshipStrategy getOverriddenStrategy() {
        JoinTableRelationship relationship = this.getOverriddenJoinTableRelationship();
        return relationship == null ? null : relationship.getJoinTableStrategy();
    }

    protected JoinTableRelationship getOverriddenJoinTableRelationship() {
        Relationship relationship = this.resolveOverriddenRelationship();
        return relationship instanceof JoinTableRelationship ? (JoinTableRelationship)relationship : null;
    }

    protected Relationship resolveOverriddenRelationship() {
        return this.getRelationship().resolveOverriddenRelationship();
    }

    public String getTableName() {
        return this.joinTable.getName();
    }

    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationship());
    }

    public TextRange getValidationTextRange() {
        return this.getRelationship().getValidationTextRange();
    }
}

