/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.Orderable;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmNamedColumn;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrderColumn2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOrderable2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlOrderColumn;
import org.eclipse.jpt.core.resource.orm.XmlOrderable;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmOrderable
extends AbstractOrmXmlContextNode
implements OrmOrderable2_0 {
    protected String specifiedOrderBy;
    protected boolean noOrdering = false;
    protected boolean pkOrdering = false;
    protected boolean customOrdering = false;
    protected final Orderable.Owner owner;
    protected boolean orderColumnOrdering = false;
    protected final OrmOrderColumn2_0 orderColumn;

    public GenericOrmOrderable(OrmAttributeMapping parent, Orderable.Owner owner) {
        super(parent);
        this.owner = owner;
        this.orderColumn = this.getXmlContextNodeFactory().buildOrmOrderColumn(this, new OrderColumnOwner());
        this.initializeOrdering();
    }

    @Override
    public void update() {
        this.updateOrdering();
    }

    @Override
    public OrmAttributeMapping getParent() {
        return (OrmAttributeMapping)super.getParent();
    }

    protected OrmPersistentAttribute getPersistentAttribute() {
        return this.getParent().getPersistentAttribute();
    }

    protected XmlOrderable getResourceOrderable() {
        return (XmlOrderable)((Object)this.getParent().getResourceAttributeMapping());
    }

    @Override
    public String getSpecifiedOrderBy() {
        return this.specifiedOrderBy;
    }

    @Override
    public void setSpecifiedOrderBy(String orderBy) {
        String old = this.specifiedOrderBy;
        this.specifiedOrderBy = orderBy;
        this.getResourceOrderable().setOrderBy(orderBy);
        this.firePropertyChanged("specifiedOrderBy", old, orderBy);
    }

    protected void setSpecifiedOrderBy_(String orderBy) {
        String old = this.specifiedOrderBy;
        this.specifiedOrderBy = orderBy;
        this.firePropertyChanged("specifiedOrderBy", old, orderBy);
    }

    protected void initializeOrdering() {
        this.specifiedOrderBy = this.getXmlOrderBy();
        XmlOrderColumn resourceOrderColumn = this.getXmlOrderColumn();
        if (this.specifiedOrderBy == null && resourceOrderColumn == null) {
            this.noOrdering = true;
        } else if (this.specifiedOrderBy != null && this.specifiedOrderBy.equals("")) {
            this.pkOrdering = true;
        } else if (resourceOrderColumn == null) {
            this.customOrdering = true;
        } else {
            this.orderColumnOrdering = true;
        }
    }

    protected void updateOrdering() {
        this.setSpecifiedOrderBy_(this.getXmlOrderBy());
        XmlOrderColumn resourceOrderColumn = this.getXmlOrderColumn();
        if (this.specifiedOrderBy == null && resourceOrderColumn == null) {
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
        } else if (this.specifiedOrderBy != null && this.specifiedOrderBy.equals("")) {
            this.setNoOrdering_(false);
            this.setPkOrdering_(true);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
        } else if (resourceOrderColumn == null) {
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(true);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(true);
        }
        this.orderColumn.update(this.getResourceOrderable());
    }

    protected String getXmlOrderBy() {
        return this.getResourceOrderable().getOrderBy();
    }

    protected XmlOrderColumn getXmlOrderColumn() {
        return this.getResourceOrderable().getOrderColumn();
    }

    @Override
    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    @Override
    public void setNoOrdering(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        if (noOrdering) {
            this.getResourceOrderable().setOrderBy(null);
            this.removeXmlOrderColumn();
        }
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    protected void setNoOrdering_(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    @Override
    public boolean isPkOrdering() {
        return this.pkOrdering;
    }

    @Override
    public void setPkOrdering(boolean pkOrdering) {
        boolean old = this.pkOrdering;
        this.pkOrdering = pkOrdering;
        if (pkOrdering) {
            this.getResourceOrderable().setOrderBy("");
            this.removeXmlOrderColumn();
        }
        this.firePropertyChanged("pkOrdering", old, pkOrdering);
    }

    protected void setPkOrdering_(boolean pkOrdering) {
        boolean old = this.pkOrdering;
        this.pkOrdering = pkOrdering;
        this.firePropertyChanged("pkOrdering", old, pkOrdering);
    }

    @Override
    public boolean isCustomOrdering() {
        return this.customOrdering;
    }

    @Override
    public void setCustomOrdering(boolean customOrdering) {
        boolean old = this.customOrdering;
        this.customOrdering = customOrdering;
        if (customOrdering) {
            this.setSpecifiedOrderBy("");
            this.removeXmlOrderColumn();
        }
        this.firePropertyChanged("customOrdering", old, customOrdering);
    }

    protected void setCustomOrdering_(boolean customOrdering) {
        boolean old = this.customOrdering;
        this.customOrdering = customOrdering;
        this.firePropertyChanged("customOrdering", old, customOrdering);
    }

    @Override
    public boolean isOrderColumnOrdering() {
        return this.orderColumnOrdering;
    }

    @Override
    public void setOrderColumnOrdering(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        if (orderColumnOrdering) {
            this.getResourceOrderable().setOrderBy(null);
            this.addXmlOrderColumn();
        }
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    protected void setOrderColumnOrdering_(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    @Override
    public OrmOrderColumn2_0 getOrderColumn() {
        return this.orderColumn;
    }

    protected void addXmlOrderColumn() {
        this.getResourceOrderable().setOrderColumn(OrmFactory.eINSTANCE.createXmlOrderColumn());
    }

    protected void removeXmlOrderColumn() {
        this.getResourceOrderable().setOrderColumn(null);
    }

    @Override
    public String getDefaultTableName() {
        return this.getOwner().getTableName();
    }

    protected Orderable2_0.Owner getOwner() {
        return (Orderable2_0.Owner)this.owner;
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getResourceOrderable().getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.isOrderColumnOrdering()) {
            this.getOrderColumn().validate(messages, reporter);
        }
    }

    public String getUnresolvedNameMessage() {
        return "ORDER_COLUMN_UNRESOLVED_NAME";
    }

    protected class OrderColumnOwner
    implements OrmNamedColumn.Owner {
        protected OrderColumnOwner() {
        }

        public String getDefaultTableName() {
            return GenericOrmOrderable.this.getDefaultTableName();
        }

        public Table getDbTable(String tableName) {
            return GenericOrmOrderable.this.getOwner().getDbTable(tableName);
        }

        public String getDefaultColumnName() {
            return String.valueOf(GenericOrmOrderable.this.getPersistentAttribute().getName()) + "_ORDER";
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmOrderable.this.getPersistentAttribute().getOwningTypeMapping();
        }

        public TextRange getValidationTextRange() {
            return GenericOrmOrderable.this.getValidationTextRange();
        }

        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            if (this.isPersistentAttributeVirtual()) {
                return this.buildVirtualUnresolvedNameMessage(column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "ORDER_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_ORDER_COLUMN_UNRESOLVED_NAME", new String[]{this.getPersistentAttributeName(), column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected boolean isPersistentAttributeVirtual() {
            return GenericOrmOrderable.this.getPersistentAttribute().isVirtual();
        }

        protected String getPersistentAttributeName() {
            return GenericOrmOrderable.this.getPersistentAttribute().getName();
        }
    }
}

