/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableTLDNamespace
extends Namespace {
    private final SerializedNamespaceData _data;
    private static final long serialVersionUID = 5364814479459691353L;

    public SerializableTLDNamespace(TLDNamespace namespace) {
        this._data = new SerializedNamespaceData(namespace.getDisplayName(), namespace.getCurrentElements(), namespace.getNSUri());
    }

    public String getDisplayName() {
        return this._data.getDisplayName();
    }

    public String getNSUri() {
        return this._data.getUri();
    }

    public ITagElement getViewElement(String name) {
        return this._data.getViewElement(name);
    }

    public Collection<? extends ITagElement> getViewElements() {
        return Collections.unmodifiableCollection(this._data.getAllViewElements().values());
    }

    public boolean hasViewElements() {
        return this._data.getNumTags() > 0;
    }

    public boolean isInitialized() {
        return this._data.isInitialized();
    }

    void put(String name, ITagElement tagElement) {
        this._data._tags.put(name, tagElement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedNamespaceData
    extends TLDNamespace.TLDNamespaceData {
        private static final long serialVersionUID = -6723194339788215607L;
        private final String _displayName;
        private final String _uri;
        private final Map<String, ITagElement> _tags;

        private SerializedNamespaceData(String displayName, Map<String, ITagElement> tags, String uri) {
            this._displayName = displayName;
            this._tags = new HashMap<String, ITagElement>();
            for (Map.Entry<String, ITagElement> tagEntry : tags.entrySet()) {
                this._tags.put(tagEntry.getKey(), tagEntry.getValue());
            }
            this._uri = uri;
        }

        @Override
        public String getDisplayName() {
            return this._displayName;
        }

        @Override
        public int getNumTags() {
            return this._tags.size();
        }

        @Override
        public ITagElement getViewElement(String name) {
            return this._tags.get(name);
        }

        @Override
        public String getUri() {
            return this._uri;
        }

        @Override
        public Map<String, ITagElement> getAllViewElements() {
            return this._tags;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public Map<String, ITagElement> getCurrentElements() {
            return this._tags;
        }
    }
}

