/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.operations;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.AbstractJpaProject;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.operations.JpaFileCreationDataModelProperties;
import org.eclipse.jpt.core.internal.utility.PlatformTools;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaFileCreationDataModelProvider
extends AbstractDataModelProvider
implements JpaFileCreationDataModelProperties {
    protected AbstractJpaFileCreationDataModelProvider() {
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("JpaFileCreationDataModelProperties.PROJECT_NAME");
        propertyNames.add("JpaFileCreationDataModelProperties.SOURCE_FOLDER");
        propertyNames.add("JpaFileCreationDataModelProperties.FILE_PATH");
        propertyNames.add("JpaFileCreationDataModelProperties.VERSION");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("JpaFileCreationDataModelProperties.SOURCE_FOLDER")) {
            IContainer sourceFolder = this.getDefaultSourceFolder();
            if (sourceFolder != null && sourceFolder.exists()) {
                return sourceFolder.getFullPath().toPortableString();
            }
        } else {
            if (propertyName.equals("JpaFileCreationDataModelProperties.FILE_PATH")) {
                return this.getDefaultFilePath();
            }
            if (propertyName.equals("JpaFileCreationDataModelProperties.VERSION")) {
                return this.getDefaultVersion();
            }
        }
        return super.getDefaultProperty(propertyName);
    }

    protected abstract String getDefaultFilePath();

    protected abstract String getDefaultVersion();

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("JpaFileCreationDataModelProperties.PROJECT_NAME")) {
            this.model.notifyPropertyChange("JpaFileCreationDataModelProperties.SOURCE_FOLDER", 2);
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("JpaFileCreationDataModelProperties.PROJECT_NAME")) {
            return (DataModelPropertyDescriptor[])ArrayTools.array((Iterator)new TransformationIterator<IProject, DataModelPropertyDescriptor>(this.jpaIProjects()){

                protected DataModelPropertyDescriptor transform(IProject next) {
                    return new DataModelPropertyDescriptor((Object)next.getName());
                }
            }, (Object[])new DataModelPropertyDescriptor[0]);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("JpaFileCreationDataModelProperties.PROJECT_NAME")) {
            return new DataModelPropertyDescriptor((Object)this.getStringProperty("JpaFileCreationDataModelProperties.PROJECT_NAME"));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    public IStatus validate(String propertyName) {
        IStatus status = Status.OK_STATUS;
        if (propertyName.equals("JpaFileCreationDataModelProperties.PROJECT_NAME") || propertyName.equals("JpaFileCreationDataModelProperties.SOURCE_FOLDER") || propertyName.equals("JpaFileCreationDataModelProperties.FILE_PATH")) {
            status = this.validateProjectSourceFolderAndFilePath();
        }
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals("JpaFileCreationDataModelProperties.PROJECT_NAME") || propertyName.equals("JpaFileCreationDataModelProperties.VERSION")) {
            status = this.validateVersion();
        }
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    protected IStatus validateProjectSourceFolderAndFilePath() {
        String projectName = (String)this.getProperty("JpaFileCreationDataModelProperties.PROJECT_NAME");
        if (StringTools.stringIsEmpty((String)projectName)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_PROJECT_NOT_SPECIFIED);
        }
        String sourceFolderPath = this.getStringProperty("JpaFileCreationDataModelProperties.SOURCE_FOLDER");
        if (StringTools.stringIsEmpty((String)sourceFolderPath)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_SOURCE_FOLDER_NOT_SPECIFIED);
        }
        if (this.sourceFolderIsIllegal(sourceFolderPath)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_SOURCE_FOLDER_ILLEGAL);
        }
        if (this.sourceFolderNotInProject(sourceFolderPath)) {
            return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_SOURCE_FOLDER_NOT_IN_PROJECT, (Object)sourceFolderPath, (Object)projectName));
        }
        if (this.getVerifiedSourceFolder() == null) {
            return new Status(4, "org.eclipse.jpt.core", NLS.bind((String)JptCoreMessages.VALIDATE_SOURCE_FOLDER_DOES_NOT_EXIST, (Object)sourceFolderPath));
        }
        String filePath = this.getStringProperty("JpaFileCreationDataModelProperties.FILE_PATH");
        if (StringTools.stringIsEmpty((String)filePath)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_FILE_PATH_NOT_SPECIFIED);
        }
        if (this.getExistingFile() != null) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_FILE_ALREADY_EXISTS);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateVersion() {
        if (this.getProject() == null) {
            return Status.OK_STATUS;
        }
        String fileVersion = this.getStringProperty("JpaFileCreationDataModelProperties.VERSION");
        if (!this.fileVersionSupported(fileVersion)) {
            return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_FILE_VERSION_NOT_SUPPORTED);
        }
        try {
            String jpaFacetVersion = this.getJpaFacetVersion(this.getProject());
            if (!this.fileVersionSupportedForFacetVersion(fileVersion, jpaFacetVersion)) {
                return new Status(4, "org.eclipse.jpt.core", JptCoreMessages.VALIDATE_FILE_VERSION_NOT_SUPPORTED_FOR_FACET_VERSION);
            }
        }
        catch (CoreException coreException) {}
        return Status.OK_STATUS;
    }

    protected abstract boolean fileVersionSupported(String var1);

    protected abstract boolean fileVersionSupportedForFacetVersion(String var1, String var2);

    protected IProject getProject() {
        String projectName = (String)this.model.getProperty("JpaFileCreationDataModelProperties.PROJECT_NAME");
        if (StringTools.stringIsEmpty((String)projectName)) {
            return null;
        }
        return ProjectUtilities.getProject((String)projectName);
    }

    protected JpaProject getJpaProject() {
        IProject project = this.getProject();
        return project == null ? null : JptCorePlugin.getJpaProject(project);
    }

    protected IContainer getDefaultSourceFolder() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IContainer folder = AbstractJpaProject.getBundleRoot(project);
        if (folder != null) {
            return folder;
        }
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources.length > 0) {
            try {
                return (IFolder)sources[0].getCorrespondingResource();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected boolean sourceFolderIsIllegal(String containerPath) {
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        IContainer container = PlatformTools.getContainer((IPath)new Path(containerPath));
        return container == null;
    }

    protected boolean sourceFolderNotInProject(String folderPath) {
        IProject project = this.getProject();
        if (project == null) {
            return false;
        }
        IContainer container = PlatformTools.getContainer((IPath)new Path(folderPath));
        return !project.equals((Object)container.getProject());
    }

    protected IContainer getVerifiedSourceFolder() {
        String folderPath = this.getStringProperty("JpaFileCreationDataModelProperties.SOURCE_FOLDER");
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IContainer container = PlatformTools.getContainer((IPath)new Path(folderPath));
        if (container == null || !container.exists()) {
            return null;
        }
        return container;
    }

    protected IFile getExistingFile() {
        IContainer container = this.getVerifiedSourceFolder();
        if (container == null) {
            return null;
        }
        String filePath = this.getStringProperty("JpaFileCreationDataModelProperties.FILE_PATH");
        IFile existingFile = container.getFile((IPath)new Path(filePath));
        if (!existingFile.exists()) {
            return null;
        }
        return existingFile;
    }

    protected Iterator<IProject> jpaIProjects() {
        return new FilteringIterator(this.allIProjects(), this.buildJpaIProjectsFilter());
    }

    protected Iterator<IProject> allIProjects() {
        return CollectionTools.iterator((Object[])ProjectUtilities.getAllProjects());
    }

    protected Filter<IProject> buildJpaIProjectsFilter() {
        return new JpaIProjectsFilter();
    }

    protected boolean hasJpaFacet(IProject project) throws CoreException {
        return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jpt.jpa");
    }

    protected String getJpaFacetVersion(IProject project) throws CoreException {
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        return fproj.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jpt.jpa")).getVersionString();
    }

    protected boolean hasSupportedPlatformId(IProject project) {
        JpaProject jpaProject = JptCorePlugin.getJpaProject(project);
        return jpaProject != null && this.isSupportedPlatformId(jpaProject.getJpaPlatform().getId());
    }

    protected boolean isSupportedPlatformId(String id) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JpaIProjectsFilter
    implements Filter<IProject> {
        protected JpaIProjectsFilter() {
        }

        public boolean accept(IProject project) {
            try {
                return this.accept_(project);
            }
            catch (CoreException coreException) {
                return false;
            }
        }

        protected boolean accept_(IProject project) throws CoreException {
            return AbstractJpaFileCreationDataModelProvider.this.hasJpaFacet(project) && AbstractJpaFileCreationDataModelProvider.this.hasSupportedPlatformId(project);
        }
    }
}

