/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.persistence;

import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericPersistenceUnitProperty
extends AbstractPersistenceXmlContextNode
implements PersistenceUnit.Property {
    protected final XmlProperty xmlProperty;
    protected String name;
    protected String value;

    public GenericPersistenceUnitProperty(PersistenceUnit parent, XmlProperty xmlProperty) {
        super(parent);
        this.xmlProperty = xmlProperty;
        this.name = xmlProperty.getName();
        this.value = xmlProperty.getValue();
    }

    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    public XmlProperty getXmlProperty() {
        return this.xmlProperty;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        if (this.attributeValueHasChanged(old, name)) {
            this.xmlProperty.setName(name);
            this.firePropertyChanged("name", old, name);
            this.getParent().propertyNameChanged(old, this.name, this.value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        String old = this.value;
        this.value = value;
        if (this.attributeValueHasChanged(old, value)) {
            this.xmlProperty.setValue(value);
            this.firePropertyChanged("value", old, value);
            this.getParent().propertyValueChanged(this.name, value);
        }
    }

    public void update() {
        this.setName(this.xmlProperty.getName());
        this.setValue(this.xmlProperty.getValue());
    }

    public TextRange getValidationTextRange() {
        return this.xmlProperty.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
    }
}

