/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contenttype;

import java.io.IOException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.html.core.internal.contenttype.AbstractResourceEncodingDetector;
import org.eclipse.wst.html.core.internal.contenttype.EncodingGuesser;
import org.eclipse.wst.html.core.internal.contenttype.HTMLHeadTokenizer;
import org.eclipse.wst.html.core.internal.contenttype.HeadParserToken;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;

public class HTMLResourceEncodingDetector
extends AbstractResourceEncodingDetector
implements IResourceCharsetDetector {
    private HTMLHeadTokenizer fTokenizer;

    public String getSpecDefaultEncoding() {
        return null;
    }

    private boolean canHandleAsUnicodeStream(String tokenType) {
        boolean canHandleAsUnicodeStream = false;
        if (tokenType == "UTF83ByteBOM") {
            canHandleAsUnicodeStream = true;
            String enc = "UTF-8";
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUTF83ByteBOMUsed(true);
        } else if (tokenType == "UTF16BE" || tokenType == "UTF16LE") {
            canHandleAsUnicodeStream = true;
            String enc = "UTF-16";
            byte[] bom = tokenType == "UTF16BE" ? IContentDescription.BOM_UTF_16BE : IContentDescription.BOM_UTF_16LE;
            this.createEncodingMemento(enc, "detectedStandardUnicodeBytes");
            this.fEncodingMemento.setUnicodeStream(true);
            this.fEncodingMemento.setUnicodeBOM(bom);
        }
        return canHandleAsUnicodeStream;
    }

    private HTMLHeadTokenizer getTokenizer() {
        this.fTokenizer = new HTMLHeadTokenizer();
        return this.fTokenizer;
    }

    private boolean isLegalString(String valueTokenType) {
        if (valueTokenType == null) {
            return false;
        }
        return valueTokenType.equals("strval") || valueTokenType.equals("UnDelimitedStringValue") || valueTokenType.equals("InvalidTerminatedStringValue") || valueTokenType.equals("InvalidTermintatedUnDelimitedStringValue");
    }

    protected void parseInput() throws IOException {
        this.checkInContent();
        if (this.fEncodingMemento == null) {
            this.checkHeuristics();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkHeuristics() throws IOException {
        boolean noHeuristic = false;
        String heuristicEncoding = null;
        try {
            try {
                if (EncodingGuesser.canGuess()) {
                    this.fReader.reset();
                    this.fReader.mark(8192);
                    byte[] bytes = new byte[8192];
                    int nRead = 0;
                    int i = 0;
                    while (i < bytes.length) {
                        int oneByte = this.fReader.read();
                        ++nRead;
                        if (oneByte == -1) break;
                        if (oneByte <= 255) {
                            bytes[i] = (byte)oneByte;
                            ++i;
                            continue;
                        }
                        noHeuristic = true;
                        break;
                    }
                    if (!noHeuristic) {
                        heuristicEncoding = EncodingGuesser.guessEncoding(bytes, nRead);
                    }
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fReader.reset();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.fReader.reset();
        if (heuristicEncoding != null) {
            this.createEncodingMemento(heuristicEncoding, "GuessEncodingFromStream");
        }
    }

    private void checkInContent() throws IOException {
        HTMLHeadTokenizer tokenizer = this.getTokenizer();
        tokenizer.reset(this.fReader);
        HeadParserToken token = null;
        String tokenType = null;
        String contentTypeValue = null;
        String xhtmlEncoding = "UNDEFINED";
        boolean isXHTML = false;
        do {
            token = tokenizer.getNextToken();
            tokenType = token.getType();
            if (tokenizer.isXHTML()) {
                isXHTML = true;
                if (!xhtmlEncoding.equals("UNDEFINED") && xhtmlEncoding.length() > 0) {
                    this.createEncodingMemento(xhtmlEncoding, "foundEncodingInContent");
                    return;
                }
            }
            if (this.canHandleAsUnicodeStream(tokenType)) continue;
            if (tokenType == "MetaTagContentType") {
                HeadParserToken valueToken;
                String valueTokenType;
                if (!tokenizer.hasMoreTokens() || !this.isLegalString(valueTokenType = (valueToken = tokenizer.getNextToken()).getType())) continue;
                contentTypeValue = valueToken.getText();
                continue;
            }
            if (tokenType != "XMLDelEncoding" || !tokenizer.hasMoreTokens() || !this.isLegalString(tokenType = (token = tokenizer.getNextToken()).getType())) continue;
            xhtmlEncoding = token.getText();
        } while (tokenizer.hasMoreTokens());
        if (contentTypeValue != null) {
            if (tokenizer.hasCharsetAttr()) {
                if ((contentTypeValue = contentTypeValue.trim()).length() > 0) {
                    this.createEncodingMemento(contentTypeValue, "foundEncodingInContent");
                }
            } else {
                this.parseContentTypeValue(contentTypeValue);
            }
        }
        if (isXHTML) {
            this.createEncodingMemento("UTF-8", "DefaultsAssumedForEmptyInput");
        }
    }

    private void parseContentTypeValue(String contentType) {
        String checkForCharset;
        String charset = null;
        Pattern pattern = Pattern.compile(";\\s*charset\\s*=\\s*");
        String[] parts = pattern.split(contentType);
        if (parts.length > 0 && parts.length == 1 && parts[0].length() > 6 && (checkForCharset = parts[0].substring(0, 7)).equalsIgnoreCase("charset")) {
            int eqpos = parts[0].indexOf(61);
            if (++eqpos < parts[0].length()) {
                charset = parts[0].substring(eqpos);
                charset = charset.trim();
            }
        }
        if (parts.length > 1) {
            charset = parts[1].trim();
        }
        if (charset != null && charset.length() > 0) {
            this.createEncodingMemento(charset, "foundEncodingInContent");
        }
    }
}

