/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaNamedNativeQuery;
import org.eclipse.jpt.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaQueryContainer
extends AbstractJavaJpaContextNode
implements JavaQueryContainer {
    protected JavaResourcePersistentMember javaResourcePersistentMember;
    protected final List<JavaNamedQuery> namedQueries = new ArrayList<JavaNamedQuery>();
    protected final List<JavaNamedNativeQuery> namedNativeQueries = new ArrayList<JavaNamedNativeQuery>();

    public GenericJavaQueryContainer(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    @Override
    public ListIterator<JavaNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public JavaNamedQuery addNamedQuery(int index) {
        JavaNamedQuery namedQuery = this.getJpaFactory().buildJavaNamedQuery(this);
        this.namedQueries.add(index, namedQuery);
        NamedQueryAnnotation namedQueryAnnotation = (NamedQueryAnnotation)this.javaResourcePersistentMember.addAnnotation(index, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.initialize(namedQueryAnnotation);
        this.fireItemAdded("namedQueries", index, namedQuery);
        return namedQuery;
    }

    protected void addNamedQuery(int index, JavaNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueries");
    }

    protected void addNamedQuery(JavaNamedQuery namedQuery) {
        this.addNamedQuery(this.namedQueries.size(), namedQuery);
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        JavaNamedQuery removedNamedQuery = this.namedQueries.remove(index);
        this.javaResourcePersistentMember.removeAnnotation(index, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        this.fireItemRemoved("namedQueries", index, removedNamedQuery);
    }

    protected void removeNamedQuery_(JavaNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueries");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentMember.moveAnnotation(targetIndex, sourceIndex, "javax.persistence.NamedQueries");
        this.fireItemMoved("namedQueries", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public JavaNamedNativeQuery addNamedNativeQuery(int index) {
        JavaNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildJavaNamedNativeQuery(this);
        this.namedNativeQueries.add(index, namedNativeQuery);
        NamedNativeQueryAnnotation namedNativeQueryAnnotation = (NamedNativeQueryAnnotation)((Object)this.javaResourcePersistentMember.addAnnotation(index, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries"));
        namedNativeQuery.initialize(namedNativeQueryAnnotation);
        this.fireItemAdded("namedNativeQueries", index, namedNativeQuery);
        return namedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, JavaNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    protected void addNamedNativeQuery(JavaNamedNativeQuery namedNativeQuery) {
        this.addNamedNativeQuery(this.namedNativeQueries.size(), namedNativeQuery);
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        JavaNamedNativeQuery removedNamedNativeQuery = this.namedNativeQueries.remove(index);
        this.javaResourcePersistentMember.removeAnnotation(index, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        this.fireItemRemoved("namedNativeQueries", index, removedNamedNativeQuery);
    }

    protected void removeNamedNativeQuery_(JavaNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedNativeQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentMember.moveAnnotation(targetIndex, sourceIndex, "javax.persistence.NamedNativeQueries");
        this.fireItemMoved("namedNativeQueries", targetIndex, sourceIndex);
    }

    @Override
    public void initialize(JavaResourcePersistentMember jrpm) {
        this.javaResourcePersistentMember = jrpm;
        this.initializeNamedQueries();
        this.initializeNamedNativeQueries();
    }

    protected void initializeNamedQueries() {
        Iterator<NestableAnnotation> stream = this.javaResourcePersistentMember.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        while (stream.hasNext()) {
            this.namedQueries.add(this.buildNamedQuery((NamedQueryAnnotation)stream.next()));
        }
    }

    protected void initializeNamedNativeQueries() {
        Iterator<NestableAnnotation> stream = this.javaResourcePersistentMember.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        while (stream.hasNext()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery((NamedNativeQueryAnnotation)((Object)stream.next())));
        }
    }

    protected JavaNamedQuery buildNamedQuery(NamedQueryAnnotation namedQueryResource) {
        JavaNamedQuery namedQuery = this.getJpaFactory().buildJavaNamedQuery(this);
        namedQuery.initialize(namedQueryResource);
        return namedQuery;
    }

    protected JavaNamedNativeQuery buildNamedNativeQuery(NamedNativeQueryAnnotation namedNativeQueryResource) {
        JavaNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildJavaNamedNativeQuery(this);
        namedNativeQuery.initialize(namedNativeQueryResource);
        return namedNativeQuery;
    }

    @Override
    public void update(JavaResourcePersistentMember jrpm) {
        this.javaResourcePersistentMember = jrpm;
        this.updateNamedQueries();
        this.updateNamedNativeQueries();
    }

    protected void updateNamedQueries() {
        ListIterator<JavaNamedQuery> queries = this.namedQueries();
        Iterator<NestableAnnotation> resourceNamedQueries = this.javaResourcePersistentMember.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        while (queries.hasNext()) {
            JavaNamedQuery namedQuery = queries.next();
            if (resourceNamedQueries.hasNext()) {
                namedQuery.update((NamedQueryAnnotation)resourceNamedQueries.next());
                continue;
            }
            this.removeNamedQuery_(namedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addNamedQuery(this.buildNamedQuery((NamedQueryAnnotation)resourceNamedQueries.next()));
        }
    }

    protected void updateNamedNativeQueries() {
        ListIterator<JavaNamedNativeQuery> queries = this.namedNativeQueries();
        Iterator<NestableAnnotation> resourceNamedNativeQueries = this.javaResourcePersistentMember.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        while (queries.hasNext()) {
            JavaNamedNativeQuery namedQuery = queries.next();
            if (resourceNamedNativeQueries.hasNext()) {
                namedQuery.update((NamedNativeQueryAnnotation)((Object)resourceNamedNativeQueries.next()));
                continue;
            }
            this.removeNamedNativeQuery_(namedQuery);
        }
        while (resourceNamedNativeQueries.hasNext()) {
            this.addNamedNativeQuery(this.buildNamedNativeQuery((NamedNativeQueryAnnotation)((Object)resourceNamedNativeQueries.next())));
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateQueries(messages, astRoot);
    }

    protected void validateQueries(List<IMessage> messages, CompilationUnit astRoot) {
        Iterator<JavaQuery> localQueries = this.queries();
        while (localQueries.hasNext()) {
            JavaQuery localQuery = localQueries.next();
            ListIterator<Query> globalQueries = this.getPersistenceUnit().queries();
            while (globalQueries.hasNext()) {
                if (!localQuery.duplicates((Query)globalQueries.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{localQuery.getName()}, localQuery, localQuery.getNameTextRange(astRoot)));
            }
        }
    }

    public Iterator<JavaQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedNativeQueries(), this.namedQueries()});
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.javaResourcePersistentMember.getTextRange(astRoot);
    }
}

