/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.jpa2.resource.java.OneToMany2_0Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceOneToManyAnnotation
extends SourceRelationshipMappingAnnotation
implements OneToMany2_0Annotation {
    protected static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OneToMany");
    private static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceOneToManyAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceOneToManyAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceOneToManyAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> MAPPED_BY_ADAPTER = SourceOneToManyAnnotation.buildMappedByAdapter();
    private final AnnotationElementAdapter<String> mappedByAdapter = this.buildAnnotationElementAdapter(MAPPED_BY_ADAPTER);
    private String mappedBy;
    private static final DeclarationAnnotationElementAdapter<Boolean> ORPHAN_REMOVAL_ADAPTER = SourceOneToManyAnnotation.buildOrphanRemovalAdapter();
    private final AnnotationElementAdapter<Boolean> orphanRemovalAdapter = this.buildBooleanAnnotationElementAdapter(ORPHAN_REMOVAL_ADAPTER);
    private Boolean orphanRemoval;

    public SourceOneToManyAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OneToMany";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.mappedBy = this.buildMappedBy(astRoot);
        this.orphanRemoval = this.buildOrphanRemoval(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncMappedBy(this.buildMappedBy(astRoot));
        this.syncOrphanRemoval(this.buildOrphanRemoval(astRoot));
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        if (this.attributeValueHasChanged(this.mappedBy, mappedBy)) {
            this.mappedBy = mappedBy;
            this.mappedByAdapter.setValue(mappedBy);
        }
    }

    private void syncMappedBy(String astMappedBy) {
        String old = this.mappedBy;
        this.mappedBy = astMappedBy;
        this.firePropertyChanged("mappedBy", old, astMappedBy);
    }

    private String buildMappedBy(CompilationUnit astRoot) {
        return this.mappedByAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMappedByTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(MAPPED_BY_ADAPTER, astRoot);
    }

    @Override
    public boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(MAPPED_BY_ADAPTER, pos, astRoot);
    }

    @Override
    public Boolean getOrphanRemoval() {
        return this.orphanRemoval;
    }

    @Override
    public void setOrphanRemoval(Boolean orphanRemoval) {
        if (this.attributeValueHasChanged(this.orphanRemoval, orphanRemoval)) {
            this.orphanRemoval = orphanRemoval;
            this.orphanRemovalAdapter.setValue(orphanRemoval);
        }
    }

    private void syncOrphanRemoval(Boolean astOrphanRemoval) {
        Boolean old = this.orphanRemoval;
        this.orphanRemoval = astOrphanRemoval;
        this.firePropertyChanged("orphanRemoval", old, astOrphanRemoval);
    }

    @Override
    public TextRange getOrphanRemovalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(ORPHAN_REMOVAL_ADAPTER, astRoot);
    }

    private Boolean buildOrphanRemoval(CompilationUnit astRoot) {
        return this.orphanRemovalAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceOneToManyAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildMappedByAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "mappedBy", false);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceOneToManyAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceOneToManyAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter() {
        return SourceOneToManyAnnotation.buildOrphanRemovalAdapter(DECLARATION_ANNOTATION_ADAPTER, "orphanRemoval");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<Boolean>(annotationAdapter, elementName, false, BooleanExpressionConverter.instance());
    }
}

