/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.eval;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptModelPresentation;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.ExpressionInformationControlCreator;
import org.eclipse.wst.jsdt.internal.ui.text.JavaWordFinder;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;

public class JavaScriptDebugHover
implements IJavaEditorTextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    static /* synthetic */ Class class$0;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object object = this.getHoverInfo2(textViewer, hoverRegion);
        if (object instanceof IVariable) {
            IVariable var = (IVariable)object;
            return JavaScriptDebugHover.getVariableText(var);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document;
        IJavaScriptStackFrame frame = this.getFrame();
        if (frame != null && (document = textViewer.getDocument()) != null) {
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                IVariable var = this.findLocalVariable(frame, variableName);
                if (var != null) {
                    return var;
                }
                var = frame.getThisObject();
                try {
                    IValue val = var.getValue();
                    if (val != null) {
                        IVariable[] vars = val.getVariables();
                        int i = 0;
                        while (i < vars.length) {
                            if (vars[i].getName().equals(variableName)) {
                                return vars[i];
                            }
                            ++i;
                        }
                    }
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    private IVariable findLocalVariable(IJavaScriptStackFrame frame, String variableName) {
        if (frame != null) {
            try {
                IVariable[] vars = frame.getVariables();
                int i = 0;
                while (i < vars.length) {
                    if (vars[i].getName().equals(variableName)) {
                        return vars[i];
                    }
                    ++i;
                }
            }
            catch (DebugException x) {
                JavaScriptDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    public void setEditor(IEditorPart editor) {
    }

    private static String getVariableText(IVariable variable) {
        StringBuffer buffer = new StringBuffer();
        JavaScriptModelPresentation modelPresentation = new JavaScriptModelPresentation();
        buffer.append("<p><pre>");
        String variableText = modelPresentation.getText(variable);
        buffer.append(JavaScriptDebugHover.replaceHTMLChars(variableText));
        buffer.append("</pre></p>");
        modelPresentation.dispose();
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuffer buffer = new StringBuffer(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    protected IJavaScriptStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IJavaScriptStackFrame)adaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

