/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.Trace;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;

public class ByteViewer
extends ContentViewer {
    protected Text text;
    protected Label encodingLabel;
    protected Combo encodingCombo;
    protected Composite byteViewerBodyComposite;
    protected String encodingType = null;
    protected byte[] contentArray;
    private static final String lineSeparator = System.getProperty("line.separator");
    protected String[] encodings = null;

    public void init(Composite parent) {
        this.byteViewerBodyComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        GridData data = new GridData(1810);
        data.horizontalSpan = 2;
        this.byteViewerBodyComposite.setLayoutData((Object)data);
        this.byteViewerBodyComposite.setLayout((Layout)layout);
        this.encodingLabel = new Label(this.byteViewerBodyComposite, 0);
        this.encodingLabel.setText(NLS.bind((String)Messages.viewEncoding, (Object)""));
        this.encodingCombo = new Combo(this.byteViewerBodyComposite, 131072);
        this.encodingCombo.add(NLS.bind((String)Messages.defaultEncodingOption, (Object)""));
        this.encodingCombo.select(0);
        if (this.encodings != null) {
            int size = this.encodings.length;
            int i = 0;
            while (i < size) {
                this.encodingCombo.add(this.encodings[i]);
                ++i;
            }
        }
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                ByteViewer.this.encodingType = ByteViewer.this.encodingCombo.getText();
                if (ByteViewer.this.contentArray != null) {
                    ByteViewer.this.setContent(ByteViewer.this.contentArray);
                }
            }
        });
        this.text = new Text(this.byteViewerBodyComposite, 2826);
        Display display = this.byteViewerBodyComposite.getDisplay();
        this.text.setLayoutData((Object)data);
        this.text.setBackground(display.getSystemColor(25));
        this.text.setForeground(display.getSystemColor(24));
        this.text.setFont(JFaceResources.getTextFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.text, "org.eclipse.wst.internet.monitor.ui.tmvw0006");
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public byte[] getContent() {
        if (this.text == null) {
            return new byte[0];
        }
        String content = this.text.getText().trim();
        if (content.equals("")) {
            return new byte[0];
        }
        byte[] twoNewlines = new byte[]{13, 10};
        byte[] contentBytes = content.getBytes();
        byte[] retBytes = new byte[contentBytes.length + 2];
        System.arraycopy(contentBytes, 0, retBytes, 0, contentBytes.length);
        System.arraycopy(twoNewlines, 0, retBytes, contentBytes.length, 2);
        return retBytes;
    }

    public void setContent(byte[] b) {
        String out = "";
        if (b != null) {
            this.contentArray = b;
            b = MonitorUIPlugin.unzip(b);
            out = this.parseEncoded(b);
        }
        int ls = lineSeparator.length();
        if (out.length() > ls) {
            while (out.substring(0, ls).indexOf(lineSeparator) >= 0) {
                out = out.substring(ls, out.length());
            }
        }
        this.text.setText(out);
    }

    public String parseEncoded(byte[] b) {
        StringBuffer sb;
        block9: {
            if (b == null) {
                throw new IllegalArgumentException();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(b);
            BufferedReader br = null;
            if (this.encodingType != null) {
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)bin, this.encodingType));
                }
                catch (UnsupportedEncodingException e) {
                    if (Trace.FINEST) {
                        Trace.trace("/finest", "An unsupported encoding exception when using encodingType=" + this.encodingType, e);
                    }
                    br = new BufferedReader(new InputStreamReader(bin));
                }
            } else {
                br = new BufferedReader(new InputStreamReader(bin));
            }
            sb = new StringBuffer();
            try {
                String s = br.readLine();
                while (s != null) {
                    sb.append(s);
                    s = br.readLine();
                    if (s == null) continue;
                    sb.append(lineSeparator);
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block9;
                Trace.trace("/severe", "Error parsing input", e);
            }
        }
        return sb.toString();
    }

    public void dispose() {
        this.text.dispose();
        this.text = null;
        this.encodingCombo.dispose();
        this.encodingCombo = null;
        this.encodingLabel.dispose();
        this.encodingLabel = null;
        this.byteViewerBodyComposite.dispose();
        this.byteViewerBodyComposite = null;
    }

    public void setEncodings(String[] str) {
        this.encodings = str;
    }
}

