/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JavaFacetUtil {
    public static final String FILE_CLASSPATH = ".classpath";
    public static final String FILE_JDT_CORE_PREFS = ".settings/org.eclipse.jdt.core.prefs";
    private static final IPath CPE_PREFIX_FOR_EXEC_ENV = new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
    private static final Map<IProjectFacetVersion, String> FACET_VER_TO_EXEC_ENV = new HashMap<IProjectFacetVersion, String>();

    static {
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_3, "J2SE-1.3");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_4, "J2SE-1.4");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_5, "J2SE-1.5");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_6, "JavaSE-1.6");
        FACET_VER_TO_EXEC_ENV.put(JavaFacet.VERSION_1_7, "JavaSE-1.7");
    }

    public static String getCompilerLevel() {
        String level = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        if (level == null) {
            Hashtable defaults = JavaCore.getDefaultOptions();
            level = (String)defaults.get("org.eclipse.jdt.core.compiler.compliance");
        }
        return level;
    }

    public static String getCompilerLevel(IProject project) {
        IJavaProject jproj = JavaCore.create((IProject)project);
        String level = jproj.getOption("org.eclipse.jdt.core.compiler.compliance", false);
        if (level == null) {
            level = JavaFacetUtil.getCompilerLevel();
        }
        return level;
    }

    public static void setCompilerLevel(IProject project, IProjectFacetVersion fv) throws CoreException {
        JavaFacetUtil.setCompilerLevel(project, fv.getVersionString());
    }

    public static void setCompilerLevel(IProject project, String level) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        Map options = jproj.getOptions(false);
        JavaCore.setComplianceOptions((String)level, (Map)options);
        jproj.setOptions(options);
    }

    public static void scheduleFullBuild(final IProject project) {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        final String msg = NLS.bind((String)Resources.buildingMsg, (Object)project.getName());
        Job buildJob = new Job(msg){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(msg, 2);
                try {
                    try {
                        project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ws.build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
            }
        };
        buildJob.setRule(ws.getRuleFactory().buildRule());
        buildJob.schedule();
    }

    public static void resetClasspath(IProject project, IProjectFacetVersion oldver, IProjectFacetVersion newver) throws CoreException {
        IVMInstall vm;
        if (oldver != null) {
            ClasspathHelper.removeClasspathEntries(project, oldver);
        }
        JavaFacetUtil.removeJreContainer(project);
        if (!ClasspathHelper.addClasspathEntries(project, newver) && (vm = JavaRuntime.getDefaultVMInstall()) != null) {
            IPath path = CPE_PREFIX_FOR_EXEC_ENV.append(JavaFacetUtil.getCorrespondingExecutionEnvironment(newver));
            IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)path);
            List<IClasspathEntry> entries = Collections.singletonList(cpe);
            ClasspathHelper.addClasspathEntries(project, newver, entries);
        }
    }

    private static void removeJreContainer(IProject proj) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)proj);
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int pos = -1;
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 5 && cpe.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            return;
        }
        IClasspathEntry[] newcp = new IClasspathEntry[cp.length - 1];
        System.arraycopy(cp, 0, newcp, 0, pos);
        System.arraycopy(cp, pos + 1, newcp, pos, newcp.length - pos);
        jproj.setRawClasspath(newcp, null);
    }

    public static String getCorrespondingExecutionEnvironment(IProjectFacetVersion fv) {
        String res = FACET_VER_TO_EXEC_ENV.get(fv);
        if (res == null) {
            throw new IllegalArgumentException(fv.toString());
        }
        return res;
    }

    private static final class Resources
    extends NLS {
        public static String buildingMsg;

        static {
            Resources.initializeMessages((String)JavaFacetUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

