/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.taginfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.DebugInfoHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;

public class BestMatchHover
implements ITextHover,
ITextHoverExtension {
    private ITextHover fBestMatchHover;
    private ITextHover[] fTagInfoHovers;
    private List fTextHovers;

    public BestMatchHover(ITextHover infoTagHover) {
        this(new ITextHover[]{infoTagHover});
    }

    public BestMatchHover(ITextHover[] infoTagHovers) {
        this.fTagInfoHovers = infoTagHovers;
    }

    private List createTextHoversList() {
        ArrayList<ITextHover> hoverList = new ArrayList<ITextHover>();
        if (Logger.isTracing("debuginfohover")) {
            hoverList.add(new DebugInfoHoverProcessor());
        }
        hoverList.add(new ProblemAnnotationHoverProcessor());
        if (this.fTagInfoHovers != null) {
            int i = 0;
            while (i < this.fTagInfoHovers.length) {
                hoverList.add(this.fTagInfoHovers[i]);
                ++i;
            }
        }
        hoverList.add(new AnnotationHoverProcessor());
        return hoverList;
    }

    public IInformationControlCreator getHoverControlCreator() {
        IInformationControlCreator creator = null;
        if (this.fBestMatchHover instanceof ITextHoverExtension) {
            creator = ((ITextHoverExtension)this.fBestMatchHover).getHoverControlCreator();
        }
        return creator;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        String displayText = null;
        if (this.fBestMatchHover != null) {
            displayText = this.fBestMatchHover.getHoverInfo(viewer, hoverRegion);
        }
        if (displayText == null) {
            Iterator i = this.getTextHovers().iterator();
            while (i.hasNext() && displayText == null) {
                ITextHover hover = (ITextHover)i.next();
                displayText = hover.getHoverInfo(viewer, hoverRegion);
            }
        }
        return displayText;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        IRegion hoverRegion = null;
        ITextHover hover = null;
        Iterator i = this.getTextHovers().iterator();
        while (i.hasNext() && hoverRegion == null) {
            hover = (ITextHover)i.next();
            hoverRegion = hover.getHoverRegion(viewer, offset);
        }
        this.fBestMatchHover = hoverRegion != null ? hover : null;
        return hoverRegion;
    }

    private List getTextHovers() {
        if (this.fTextHovers == null) {
            this.fTextHovers = this.createTextHoversList();
        }
        return this.fTextHovers;
    }
}

