/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AppClientFacetInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            try {
                IDataModel model = (IDataModel)config;
                IJavaProject jproj = JavaCore.create((IProject)project);
                WtpUtils.addNatures((IProject)project);
                this.createFlexibleProject(monitor, project, model, jproj, fv);
                ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                if (model.getBooleanProperty("IJ2EEModuleFacetInstallDataModelProperties.INSTALL_EAR_LIBRARY")) {
                    Path earLibContainer = new Path("org.eclipse.jst.j2ee.internal.module.container");
                    AppClientFacetInstallDelegate.addToClasspath(jproj, JavaCore.newContainerEntry((IPath)earLibContainer));
                }
                try {
                    ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
                }
                catch (ExecutionException e) {
                    J2EEPlugin.logError(e);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                J2EEPlugin.logError(e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected IVirtualComponent createFlexibleProject(IProgressMonitor monitor, IProject project, IDataModel model, IJavaProject jproj, IProjectFacetVersion fv) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IPath pjpath = project.getFullPath();
        IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
        c.create(0, null);
        this.setOutputFolder(model, c);
        IVirtualFolder root = c.getRootFolder();
        IFolder sourceFolder = null;
        String configFolder = null;
        configFolder = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        root.createLink((IPath)new Path("/" + configFolder), 0, null);
        String configFolderName = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        IPath configFolderpath = pjpath.append(configFolderName);
        sourceFolder = ws.getRoot().getFolder(configFolderpath);
        if (fv == IJ2EEFacetConstants.APPLICATION_CLIENT_60 || fv == IJ2EEFacetConstants.APPLICATION_CLIENT_50) {
            IFile appClientFile;
            if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD") && !(appClientFile = sourceFolder.getFile((IPath)new Path("META-INF/application-client.xml"))).exists()) {
                try {
                    if (!appClientFile.getParent().exists() && appClientFile.getParent().getType() == 2) {
                        ((IFolder)appClientFile.getParent()).create(true, true, monitor);
                    }
                    String appClientXmlContents = null;
                    appClientXmlContents = fv == IJ2EEFacetConstants.APPLICATION_CLIENT_60 ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<application-client version=\"6\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_6.xsd\">\n <display-name>" + XMLWriter.getEscaped((String)project.getName()) + "</display-name> \n </application-client>" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<application-client version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd\">\n <display-name>" + XMLWriter.getEscaped((String)project.getName()) + "</display-name> \n </application-client>";
                    appClientFile.create((InputStream)new ByteArrayInputStream(appClientXmlContents.getBytes("UTF-8")), true, monitor);
                }
                catch (UnsupportedEncodingException e) {
                    J2EEPlugin.logError(e);
                }
            }
        } else if (!sourceFolder.getFile("META-INF/application-client.xml").exists()) {
            String ver = model.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
            int nVer = J2EEVersionUtil.convertVersionStringToInt(ver);
            AppClientArtifactEdit.createDeploymentDescriptor(project, nVer);
        }
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 3) {
                root.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
            }
            ++i;
        }
        return c;
    }
}

