/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class ControlStatementsFix
extends AbstractFix {
    public static IFix[] createRemoveBlockFix(JavaScriptUnit compilationUnit, ASTNode node) {
        RemoveBlockOperation op;
        Statement statement = ASTResolving.findParentStatement(node);
        if (statement == null) {
            return null;
        }
        if (statement instanceof Block) {
            Block block = (Block)statement;
            if (block.statements().size() != 1) {
                return null;
            }
            ASTNode parent = block.getParent();
            if (!(parent instanceof Statement)) {
                return null;
            }
            statement = (Statement)parent;
        }
        if (statement instanceof IfStatement) {
            RemoveBlockOperation op2;
            ArrayList<ControlStatementsFix> result = new ArrayList<ControlStatementsFix>();
            ArrayList<RemoveBlockOperation> removeAllList = new ArrayList<RemoveBlockOperation>();
            IfElseIterator iter = new IfElseIterator((IfStatement)statement);
            IfStatement item = null;
            while (iter.hasNext()) {
                item = iter.next();
                if (!RemoveBlockOperation.satisfiesQuickAssistPrecondition((Statement)item, IfStatement.THEN_STATEMENT_PROPERTY)) continue;
                op2 = new RemoveBlockOperation((Statement)item, IfStatement.THEN_STATEMENT_PROPERTY);
                removeAllList.add(op2);
                if (item != statement) continue;
                result.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeIfBlock_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op2}));
            }
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(item, IfStatement.ELSE_STATEMENT_PROPERTY)) {
                op2 = new RemoveBlockOperation((Statement)item, IfStatement.ELSE_STATEMENT_PROPERTY);
                removeAllList.add(op2);
                if (item == statement) {
                    result.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeElseBlock_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op2}));
                }
            }
            if (removeAllList.size() > 1) {
                IFixRewriteOperation[] allConvert = removeAllList.toArray(new IFixRewriteOperation[removeAllList.size()]);
                result.add(new ControlStatementsFix(FixMessages.ControlStatementsFix_removeIfElseBlock_proposalDescription, compilationUnit, allConvert));
            }
            return result.toArray(new IFix[result.size()]);
        }
        if (statement instanceof WhileStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, WhileStatement.BODY_PROPERTY)) {
                op = new RemoveBlockOperation(statement, WhileStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op})};
            }
        } else if (statement instanceof ForStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, ForStatement.BODY_PROPERTY)) {
                op = new RemoveBlockOperation(statement, ForStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op})};
            }
        } else if (statement instanceof ForInStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, ForInStatement.BODY_PROPERTY)) {
                op = new RemoveBlockOperation(statement, ForInStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op})};
            }
        } else if (statement instanceof EnhancedForStatement) {
            if (RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, EnhancedForStatement.BODY_PROPERTY)) {
                op = new RemoveBlockOperation(statement, EnhancedForStatement.BODY_PROPERTY);
                return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op})};
            }
        } else if (statement instanceof DoStatement && RemoveBlockOperation.satisfiesQuickAssistPrecondition(statement, DoStatement.BODY_PROPERTY)) {
            op = new RemoveBlockOperation(statement, DoStatement.BODY_PROPERTY);
            return new IFix[]{new ControlStatementsFix(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription, compilationUnit, new IFixRewriteOperation[]{op})};
        }
        return null;
    }

    public static IFix createCleanUp(JavaScriptUnit compilationUnit, boolean convertSingleStatementToBlock, boolean removeUnnecessaryBlock, boolean removeUnnecessaryBlockContainingReturnOrThrow) throws CoreException {
        if (!(convertSingleStatementToBlock || removeUnnecessaryBlock || removeUnnecessaryBlockContainingReturnOrThrow)) {
            return null;
        }
        ArrayList operations = new ArrayList();
        ControlStatementFinder finder = new ControlStatementFinder(convertSingleStatementToBlock, removeUnnecessaryBlock, removeUnnecessaryBlockContainingReturnOrThrow, operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] ops = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new ControlStatementsFix(FixMessages.ControlStatementsFix_change_name, compilationUnit, ops);
    }

    protected ControlStatementsFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class AddBlockOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ChildPropertyDescriptor fBodyProperty;
        private final Statement fBody;
        private final Statement fControlStatement;

        public AddBlockOperation(ChildPropertyDescriptor bodyProperty, Statement body, Statement controlStatement) {
            this.fBodyProperty = bodyProperty;
            this.fBody = body;
            this.fControlStatement = controlStatement;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            String label = this.fBodyProperty == IfStatement.THEN_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeIfToBlock_desription : (this.fBodyProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? FixMessages.CodeStyleFix_ChangeElseToBlock_description : FixMessages.CodeStyleFix_ChangeControlToBlock_description);
            TextEditGroup group = this.createTextEditGroup(label);
            textEditGroups.add(group);
            ASTNode moveTarget = rewrite.createMoveTarget((ASTNode)this.fBody);
            Block replacingBody = cuRewrite.getRoot().getAST().newBlock();
            replacingBody.statements().add(moveTarget);
            rewrite.set((ASTNode)this.fControlStatement, (StructuralPropertyDescriptor)this.fBodyProperty, (Object)replacingBody, group);
        }
    }

    private static final class ControlStatementFinder
    extends GenericVisitor {
        private final List fResult;
        private final boolean fFindControlStatementsWithoutBlock;
        private final boolean fRemoveUnnecessaryBlocks;
        private final boolean fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow;

        public ControlStatementFinder(boolean findControlStatementsWithoutBlock, boolean removeUnnecessaryBlocks, boolean removeUnnecessaryBlocksOnlyWhenReturnOrThrow, List resultingCollection) {
            this.fFindControlStatementsWithoutBlock = findControlStatementsWithoutBlock;
            this.fRemoveUnnecessaryBlocks = removeUnnecessaryBlocks;
            this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow = removeUnnecessaryBlocksOnlyWhenReturnOrThrow;
            this.fResult = resultingCollection;
        }

        public boolean visit(DoStatement node) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement doBody = node.getBody();
                if (!(doBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(DoStatement.BODY_PROPERTY, doBody, (Statement)node));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)node, DoStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)node, DoStatement.BODY_PROPERTY));
            }
            return super.visit(node);
        }

        public boolean visit(ForStatement node) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement forBody = node.getBody();
                if (!(forBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(ForStatement.BODY_PROPERTY, forBody, (Statement)node));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)node, ForStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)node, ForStatement.BODY_PROPERTY));
            }
            return super.visit(node);
        }

        public boolean visit(EnhancedForStatement node) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement forBody = node.getBody();
                if (!(forBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(EnhancedForStatement.BODY_PROPERTY, forBody, (Statement)node));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)node, EnhancedForStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)node, EnhancedForStatement.BODY_PROPERTY));
            }
            return super.visit(node);
        }

        public boolean visit(IfStatement statement) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement elseStatement;
                Statement then = statement.getThenStatement();
                if (!(then instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(IfStatement.THEN_STATEMENT_PROPERTY, then, (Statement)statement));
                }
                if ((elseStatement = statement.getElseStatement()) != null && !(elseStatement instanceof Block) && !(elseStatement instanceof IfStatement)) {
                    this.fResult.add(new AddBlockOperation(IfStatement.ELSE_STATEMENT_PROPERTY, elseStatement, (Statement)statement));
                }
            } else if (this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) {
                if (RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)statement, IfStatement.THEN_STATEMENT_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                    this.fResult.add(new RemoveBlockOperation((Statement)statement, IfStatement.THEN_STATEMENT_PROPERTY));
                }
                if (!(statement.getElseStatement() instanceof IfStatement) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)statement, IfStatement.ELSE_STATEMENT_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                    this.fResult.add(new RemoveBlockOperation((Statement)statement, IfStatement.ELSE_STATEMENT_PROPERTY));
                }
            }
            return super.visit(statement);
        }

        public boolean visit(WhileStatement node) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement whileBody = node.getBody();
                if (!(whileBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(WhileStatement.BODY_PROPERTY, whileBody, (Statement)node));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)node, WhileStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)node, WhileStatement.BODY_PROPERTY));
            }
            return super.visit(node);
        }

        public boolean visit(WithStatement node) {
            if (this.fFindControlStatementsWithoutBlock) {
                Statement withBody = node.getBody();
                if (!(withBody instanceof Block)) {
                    this.fResult.add(new AddBlockOperation(WithStatement.BODY_PROPERTY, withBody, (Statement)node));
                }
            } else if ((this.fRemoveUnnecessaryBlocks || this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow) && RemoveBlockOperation.satisfiesCleanUpPrecondition((Statement)node, WithStatement.BODY_PROPERTY, this.fRemoveUnnecessaryBlocksOnlyWhenReturnOrThrow)) {
                this.fResult.add(new RemoveBlockOperation((Statement)node, WithStatement.BODY_PROPERTY));
            }
            return super.visit(node);
        }
    }

    private static class IfElseIterator {
        private IfStatement fCursor;

        public IfElseIterator(IfStatement item) {
            this.fCursor = this.findStart(item);
        }

        public IfStatement next() {
            if (!this.hasNext()) {
                return null;
            }
            IfStatement result = this.fCursor;
            this.fCursor = this.fCursor.getElseStatement() instanceof IfStatement ? (IfStatement)this.fCursor.getElseStatement() : null;
            return result;
        }

        public boolean hasNext() {
            return this.fCursor != null;
        }

        private IfStatement findStart(IfStatement item) {
            while (item.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                item = (IfStatement)item.getParent();
            }
            return item;
        }
    }

    static class RemoveBlockOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final Statement fStatement;
        private final ChildPropertyDescriptor fChild;

        public RemoveBlockOperation(Statement controlStatement, ChildPropertyDescriptor child) {
            this.fStatement = controlStatement;
            this.fChild = child;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            Block block = (Block)this.fStatement.getStructuralProperty((StructuralPropertyDescriptor)this.fChild);
            Statement statement = (Statement)block.statements().get(0);
            Statement moveTarget = (Statement)rewrite.createMoveTarget((ASTNode)statement);
            TextEditGroup group = this.createTextEditGroup(FixMessages.ControlStatementsFix_removeBrackets_proposalDescription);
            textEditGroups.add(group);
            rewrite.set((ASTNode)this.fStatement, (StructuralPropertyDescriptor)this.fChild, (Object)moveTarget, group);
        }

        public static boolean satisfiesCleanUpPrecondition(Statement controlStatement, ChildPropertyDescriptor childDescriptor, boolean onlyReturnAndThrows) {
            return RemoveBlockOperation.satisfiesPrecondition(controlStatement, childDescriptor, onlyReturnAndThrows, true);
        }

        public static boolean satisfiesQuickAssistPrecondition(Statement controlStatement, ChildPropertyDescriptor childDescriptor) {
            return RemoveBlockOperation.satisfiesPrecondition(controlStatement, childDescriptor, false, false);
        }

        private static boolean satisfiesPrecondition(Statement controlStatement, ChildPropertyDescriptor childDescriptor, boolean onlyReturnAndThrows, boolean cleanUpCheck) {
            Object child = controlStatement.getStructuralProperty((StructuralPropertyDescriptor)childDescriptor);
            if (!(child instanceof Block)) {
                return false;
            }
            Block block = (Block)child;
            List list = block.statements();
            if (list.size() != 1) {
                return false;
            }
            ASTNode singleStatement = (ASTNode)list.get(0);
            if (onlyReturnAndThrows && !(singleStatement instanceof ReturnStatement) && !(singleStatement instanceof ThrowStatement)) {
                return false;
            }
            if (controlStatement instanceof IfStatement) {
                if (((IfStatement)controlStatement).getThenStatement() != child) {
                    return true;
                }
                IfStatement ifStatement = (IfStatement)controlStatement;
                if (ifStatement.getElseStatement() == null) {
                    return true;
                }
                return !RemoveBlockOperation.hasUnblockedIf((Statement)singleStatement, onlyReturnAndThrows, cleanUpCheck);
            }
            if (!RemoveBlockOperation.hasUnblockedIf((Statement)singleStatement, onlyReturnAndThrows, cleanUpCheck)) {
                return true;
            }
            Statement currentChild = controlStatement;
            ASTNode parent = currentChild.getParent();
            while (true) {
                Statement body = null;
                if (parent instanceof IfStatement) {
                    body = ((IfStatement)parent).getThenStatement();
                    if (body == currentChild && ((IfStatement)parent).getElseStatement() != null) {
                        return false;
                    }
                } else if (parent instanceof WhileStatement) {
                    body = ((WhileStatement)parent).getBody();
                } else if (parent instanceof WithStatement) {
                    body = ((WithStatement)parent).getBody();
                } else if (parent instanceof DoStatement) {
                    body = ((DoStatement)parent).getBody();
                } else if (parent instanceof ForStatement) {
                    body = ((ForStatement)parent).getBody();
                } else if (parent instanceof EnhancedForStatement) {
                    body = ((EnhancedForStatement)parent).getBody();
                } else {
                    return true;
                }
                if (body != currentChild) {
                    return true;
                }
                currentChild = parent;
                parent = currentChild.getParent();
            }
        }

        private static boolean hasUnblockedIf(Statement p, boolean onlyReturnAndThrows, boolean cleanUpCheck) {
            while (!(p instanceof IfStatement)) {
                ChildPropertyDescriptor childD = null;
                if (p instanceof WhileStatement) {
                    childD = WhileStatement.BODY_PROPERTY;
                } else if (p instanceof WithStatement) {
                    childD = WithStatement.BODY_PROPERTY;
                } else if (p instanceof ForStatement) {
                    childD = ForStatement.BODY_PROPERTY;
                } else if (p instanceof EnhancedForStatement) {
                    childD = EnhancedForStatement.BODY_PROPERTY;
                } else if (p instanceof DoStatement) {
                    childD = DoStatement.BODY_PROPERTY;
                } else {
                    return false;
                }
                Statement body = (Statement)p.getStructuralProperty((StructuralPropertyDescriptor)childD);
                if (body instanceof Block) {
                    if (!cleanUpCheck) {
                        return false;
                    }
                    if (!RemoveBlockOperation.satisfiesPrecondition(p, childD, onlyReturnAndThrows, cleanUpCheck)) {
                        return false;
                    }
                    p = (Statement)((Block)body).statements().get(0);
                    continue;
                }
                p = body;
            }
            return true;
        }
    }
}

