/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;

public class IndentationTabPage
extends FormatterTabPage {
    private static String[] FALSE_TRUE = new String[]{"false", "true"};
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "function foo(data) {\n" + "\n" + "    var abc = 1;\n" + "    var xyz = 'one';\n" + "\n" + "    switch (data) {\n" + "\n" + "        case 0:\n" + "            abc = 0;\n" + "            xyz = 'zero';\n" + "            break;\n" + "\n" + "        default:\n" + "            abc = -1;\n" + "            xyz = 'unknown';\n" + "\n" + "     }\n\n" + "    if ( document.form1.year.value > 2000 ) {\n" + "        abc += 27;\n" + "    }\n" + "    else if ( document.form1.year.value > 1900 ) {\n" + "        abc += 19;\n" + "    }\n" + "    else {\n" + "        abc = 0;\n" + "    }\n" + "\n" + "}";
    private CompilationUnitPreview fPreview;
    private String fOldTabChar = null;

    public IndentationTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference tabPolicy = this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "org.eclipse.wst.jsdt.core.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.CheckboxPreference onlyForLeading = this.createCheckboxPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "org.eclipse.wst.jsdt.core.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "org.eclipse.wst.jsdt.core.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char");
        this.updateTabPreferences(tabchar, tabSize, indentSize, onlyForLeading);
        tabPolicy.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                IndentationTabPage.this.updateTabPreferences((String)arg, tabSize, indentSize, onlyForLeading);
            }
        });
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
        Group typeMemberGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_field_alignment_group_title);
        this.createCheckboxPref((Composite)typeMemberGroup, numColumns, FormatterMessages.IndentationTabPage_field_alignment_group_align_fields_in_columns, "org.eclipse.wst.jsdt.core.formatter.align_type_members_on_columns", FALSE_TRUE);
        Group classGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_body, "org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_body", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_block_group_option_indent_statements_compare_to_block, "org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_block", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_switch_body, "org.eclipse.wst.jsdt.core.formatter.indent_switchstatements_compare_to_switch", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_statements_within_case_body, "org.eclipse.wst.jsdt.core.formatter.indent_switchstatements_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_switch_group_option_indent_break_statements, "org.eclipse.wst.jsdt.core.formatter.indent_breaks_compare_to_cases", FALSE_TRUE);
        this.createCheckboxPref((Composite)classGroup, numColumns, FormatterMessages.IndentationTabPage_indent_empty_lines, "org.eclipse.wst.jsdt.core.formatter.indent_empty_lines", FALSE_TRUE);
    }

    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if ("space".equals(this.fOldTabChar) || "tab".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.eclipse.wst.jsdt.core.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if ("space".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.wst.jsdt.core.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("tab".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        Object tabSize = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.tabulation.size");
        Object indentSize = this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.indentation.size");
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("org.eclipse.wst.jsdt.core.formatter.indentation.size", tabSize);
    }
}

