/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.io.CharConversionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ExtractSuperClassAction
extends SelectionDispatchAction {
    public static final String EXTRACT_SUPERTYPE = "org.eclipse.wst.jsdt.ui.edit.text.java.extract.superclass";
    public static final String EXTRACT_SUPERTYPES = "org.eclipse.wst.jsdt.ui.actions.ExtractSuperclass";
    private JavaEditor fEditor;

    private static IMember[] getSelectedMembers(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection.size() == 1) {
            try {
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return new IType[]{type};
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof IMember) continue;
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(Arrays.asList(selection.toArray()));
        return set.toArray(new IMember[set.size()]);
    }

    public ExtractSuperClassAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ExtractSuperClassAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ExtractSuperTypeAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.extract_supertype_action");
    }

    private IMember getSelectedMemberFromEditor() throws JavaScriptModelException {
        IJavaScriptElement element = SelectionConverter.resolveEnclosingElement(this.fEditor, (ITextSelection)this.fEditor.getSelectionProvider().getSelection());
        if (element == null || !(element instanceof IMember)) {
            return null;
        }
        return (IMember)element;
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember[] members = ExtractSuperClassAction.getSelectedMembers(selection);
            if (RefactoringAvailabilityTester.isExtractSupertypeAvailable(members) && ActionUtil.isEditable(this.getShell(), (IJavaScriptElement)members[0])) {
                RefactoringExecutionStarter.startExtractSupertypeRefactoring(members, this.getShell());
            }
        }
        catch (JavaScriptModelException exception) {
            ExceptionHandler.handle((CoreException)((Object)exception), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            IMember member = this.getSelectedMemberFromEditor();
            IMember[] array = new IMember[]{member};
            if (member != null && RefactoringAvailabilityTester.isExtractSupertypeAvailable(array)) {
                RefactoringExecutionStarter.startExtractSupertypeRefactoring(array, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.ExtractSuperTypeAction_unavailable);
            }
        }
        catch (JavaScriptModelException exception) {
            ExceptionHandler.handle((CoreException)((Object)exception), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExtractSupertypeAvailable(selection));
        }
        catch (JavaScriptModelException exception) {
            if (!(exception.getException() instanceof CharConversionException) && JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)exception))) {
                JavaScriptPlugin.log(exception);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExtractSupertypeAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }
}

