/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.actions;

import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItemFactory;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;
import org.eclipse.wst.common.snippets.internal.util.UserDrawerSelector;

public class AddToSnippetsEditorActionDelegate
implements IEditorActionDelegate,
IViewActionDelegate {
    private IAction fAction;
    private IEditorPart fEditorPart;
    private IViewPart fViewPart = null;
    static /* synthetic */ Class class$0;

    public IDocument getDocument() {
        return this.getTextEditor().getDocumentProvider().getDocument((Object)this.fEditorPart.getEditorInput());
    }

    protected ITextSelection getSelection() {
        ISelection selection;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (selection = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return new TextSelection(0, 0);
    }

    protected ITextEditor getTextEditor() {
        ITextEditor editor = null;
        IViewPart activePart = this.fViewPart;
        if (activePart == null) {
            activePart = this.fEditorPart;
        }
        if (activePart instanceof ITextEditor) {
            editor = (ITextEditor)activePart;
        }
        if (editor == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            editor = (ITextEditor)activePart.getAdapter((Class)clazz);
        }
        return editor;
    }

    protected PaletteDrawer getUserDrawer() {
        UserDrawerSelector selector = new UserDrawerSelector(this.fEditorPart.getEditorSite().getShell());
        PaletteDrawer drawer = selector.getUserDrawer();
        return drawer;
    }

    public void init(IViewPart view) {
        this.fViewPart = view;
    }

    public void run(IAction action) {
        PaletteDrawer drawer = this.getUserDrawer();
        if (drawer != null) {
            ITextSelection selection = this.getSelection();
            String selectedText = null;
            try {
                selectedText = this.getDocument().get(selection.getOffset(), selection.getLength());
                SnippetPaletteItem item = (SnippetPaletteItem)new SnippetPaletteItemFactory().createNewEntry(this.fEditorPart.getSite().getShell(), (PaletteEntry)drawer);
                item.setDescription(String.valueOf(StringUtils.firstLineOf(selectedText).trim()) + "...");
                item.setContentString(selectedText);
                IViewPart snippets = this.fEditorPart.getEditorSite().getPage().showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
                PaletteCustomizerDialog dialog = ((SnippetsView)snippets).getViewer().getCustomizerDialog();
                dialog.setDefaultSelection((PaletteEntry)item);
                dialog.open();
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
            catch (PartInitException e1) {
                Logger.logException(e1);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.updateWith(selection);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditorPart = targetEditor;
        this.fAction = action;
        if (targetEditor != null && targetEditor.getEditorSite() != null && targetEditor.getEditorSite().getSelectionProvider() != null) {
            this.updateWith(targetEditor.getEditorSite().getSelectionProvider().getSelection());
        }
    }

    public void updateWith(ISelection selection) {
        if (this.fAction != null) {
            boolean enable = false;
            if (selection != null) {
                if (selection instanceof ITextSelection) {
                    if (((ITextSelection)selection).getLength() > 0) {
                        enable = true;
                    }
                } else {
                    enable = !selection.isEmpty();
                }
            }
            this.fAction.setEnabled(enable);
        }
    }
}

