/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.menus;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.internal.jface.ImageImageDescriptor;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapAsContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        IHandlerService handlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        IStructuredSelection currentSelection = (IStructuredSelection)handlerService.getCurrentState().getVariable("selection");
        JpaStructureNode node = (JpaStructureNode)currentSelection.getFirstElement();
        return (IContributionItem[])CollectionTools.array((Iterator)new TransformationIterator<MappingUiProvider<?>, IContributionItem>(this.mappingUiProviders(node)){

            protected IContributionItem transform(MappingUiProvider<?> next) {
                return MapAsContribution.this.contributionItem(next);
            }
        }, (Object[])new IContributionItem[0]);
    }

    protected Iterator<? extends MappingUiProvider<?>> mappingUiProviders(JpaStructureNode node) {
        JpaPlatform jpaPlatform = node.getJpaProject().getJpaPlatform();
        JpaPlatformUi jpaPlatformUi = JptUiPlugin.getPlugin().jpaPlatformUi(jpaPlatform);
        return this.mappingUiProviders(jpaPlatformUi, node);
    }

    protected abstract Iterator<? extends MappingUiProvider<?>> mappingUiProviders(JpaPlatformUi var1, JpaStructureNode var2);

    protected IContributionItem contributionItem(MappingUiProvider<?> mappingUiProvider) {
        CommandContributionItem item = new CommandContributionItem(this.parameter(mappingUiProvider));
        return item;
    }

    protected CommandContributionItemParameter parameter(MappingUiProvider<?> mappingUiProvider) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(this.serviceLocator, this.createCommandContributionItemId(mappingUiProvider), this.commandId(), 32);
        parameter.label = mappingUiProvider.getLabel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(this.commandParameterId(), mappingUiProvider.getMappingKey());
        parameter.parameters = parameters;
        parameter.icon = new ImageImageDescriptor(mappingUiProvider.getImage());
        parameter.visibleEnabled = true;
        return parameter;
    }

    protected abstract String commandId();

    protected abstract String commandParameterId();

    protected String createCommandContributionItemId(MappingUiProvider<?> mappingUiProvider) {
        return String.valueOf(this.commandId()) + "." + mappingUiProvider.getMappingKey();
    }
}

