/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IPathSensitiveMetaDataLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataLocatorFactory
implements IResourceChangeListener {
    private static MetaDataLocatorFactory INSTANCE = null;
    private Map<String, IMetaDataLocator> _locators;
    private static final boolean DEBUG = false;

    public static synchronized MetaDataLocatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataLocatorFactory();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)INSTANCE, 2);
        }
        return INSTANCE;
    }

    private Map<String, IMetaDataLocator> getLocators() {
        if (this._locators == null) {
            this._locators = new HashMap<String, IMetaDataLocator>();
        }
        return this._locators;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMetaDataLocator getLocator(String locatorClassName, String bundleId, IProject project) {
        Class<?> klass = JSFCommonPlugin.loadClass(locatorClassName, bundleId);
        String key = this.getKey(locatorClassName, bundleId);
        IMetaDataLocator locator = null;
        try {
            IMetaDataLocator tempLocator = (IMetaDataLocator)klass.newInstance();
            if (tempLocator == null) return locator;
            if (tempLocator instanceof IPathSensitiveMetaDataLocator) {
                if (project == null) {
                    return null;
                }
                key = this.getKey(locatorClassName, project.getName());
            }
            if ((locator = this.getLocators().get(key)) != null) return locator;
            locator = tempLocator;
            if (locator instanceof IPathSensitiveMetaDataLocator) {
                ((IPathSensitiveMetaDataLocator)locator).setProjectContext(project);
            }
            this.getLocators().put(key, locator);
            locator.startLocating();
            return locator;
        }
        catch (InstantiationException e) {
            JSFCommonPlugin.log(4, "Could not instantiate IMetaDataLocator: " + key, e);
            return locator;
        }
        catch (IllegalAccessException e) {
            JSFCommonPlugin.log(4, "IllegalAccessException while creating IMetaDataLocator: " + key, e);
        }
        return locator;
    }

    private String getKey(String locatorClassName, String contextId) {
        StringBuffer buf = new StringBuffer(contextId);
        buf.append(":");
        buf.append(locatorClassName);
        return buf.toString();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        for (IMetaDataLocator locator : this.getLocators().values()) {
            locator.stopLocating();
        }
        this.getLocators().clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject aProject;
        if ((event.getType() == 2 || event.getType() == 4) && (aProject = (IProject)event.getResource()) != null) {
            ArrayList<String> locatorsToRemove = new ArrayList<String>();
            for (String key : this.getLocators().keySet()) {
                if (!this.locatorIsForProject(key, aProject.getName())) continue;
                locatorsToRemove.add(key);
            }
            if (!locatorsToRemove.isEmpty()) {
                for (String key : locatorsToRemove) {
                    IMetaDataLocator locator = this.getLocators().get(key);
                    locator.stopLocating();
                    this.getLocators().remove(key);
                }
            }
        }
    }

    private boolean locatorIsForProject(String key, String projectName) {
        StringTokenizer t = new StringTokenizer(key, ":");
        String contextId = t.nextToken();
        return contextId.equals(projectName);
    }
}

