/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ReconcileStepForValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.MutableWorkspaceSettings;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ValidatorStrategy
extends StructuredTextReconcilingStrategy {
    private String[] fContentTypeIds = null;
    private List fMetaData = new ArrayList();
    private HashMap fVidToVStepMap = null;
    private List fTotalScopeValidatorsAlreadyRun;
    private IValChangedListener fValChangedListener;

    public ValidatorStrategy(ISourceViewer sourceViewer, String contentType) {
        super(sourceViewer);
        this.fContentTypeIds = this.calculateParentContentTypeIds(contentType);
        this.fVidToVStepMap = new HashMap();
        this.fValChangedListener = new ValChangedListener();
        ValPrefManagerGlobal.getDefault().addListener(this.fValChangedListener);
        ValPrefManagerProject.addListener((IValChangedListener)this.fValChangedListener);
    }

    public void addValidatorMetaData(ValidatorMetaData vmd) {
        this.fMetaData.add(vmd);
    }

    public void beginProcessing() {
        if (this.fTotalScopeValidatorsAlreadyRun == null) {
            this.fTotalScopeValidatorsAlreadyRun = new ArrayList();
        } else {
            this.fTotalScopeValidatorsAlreadyRun.clear();
        }
    }

    private String[] calculateParentContentTypeIds(String contentTypeId) {
        HashSet<String> parentTypes = new HashSet<String>();
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType ct = ctManager.getContentType(contentTypeId);
        String id = contentTypeId;
        while (ct != null && id != null) {
            parentTypes.add(id);
            ct = ctManager.getContentType(id);
            if (ct == null) continue;
            IContentType baseType = ct.getBaseType();
            String string = id = baseType != null ? baseType.getId() : null;
        }
        return parentTypes.toArray(new String[parentTypes.size()]);
    }

    protected boolean canHandlePartition(String partitionType) {
        ValidatorMetaData vmd = null;
        int i = 0;
        while (i < this.fMetaData.size()) {
            vmd = (ValidatorMetaData)this.fMetaData.get(i);
            if (vmd.canHandlePartitionType(this.getContentTypeIds(), partitionType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean containsStep(IReconcileStep step) {
        return this.fVidToVStepMap.containsValue(step);
    }

    public void createReconcileSteps() {
    }

    public void endProcessing() {
        this.fTotalScopeValidatorsAlreadyRun.clear();
    }

    public String[] getContentTypeIds() {
        return this.fContentTypeIds;
    }

    public void reconcile(ITypedRegion tr, DirtyRegion dr) {
        IFile file = this.getFile();
        if (this.isCanceled() || this.fMetaData.isEmpty() || file != null && ValidatorStrategy.areAllValidatorsSuspended(file)) {
            return;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        String partitionType = tr.getType();
        ValidatorMetaData vmd = null;
        ArrayList<IReconcileResult> annotationsToAdd = new ArrayList<IReconcileResult>();
        ArrayList<ReconcileStepForValidator> stepsRanOnThisDirtyRegion = new ArrayList<ReconcileStepForValidator>(1);
        HashSet disabledValsBySourceId = new HashSet(20);
        HashSet disabledValsByClass = new HashSet(20);
        ValidatorStrategy.getDisabledValidators(file, disabledValsBySourceId, disabledValsByClass);
        int i = 0;
        while (i < this.fMetaData.size() && !this.isCanceled()) {
            vmd = (ValidatorMetaData)this.fMetaData.get(i);
            if (vmd.canHandlePartitionType(this.getContentTypeIds(), partitionType) && !disabledValsBySourceId.contains(vmd.getValidatorId()) && !disabledValsByClass.contains(vmd.getValidatorClass())) {
                int validatorScope = vmd.getValidatorScope();
                ReconcileStepForValidator validatorStep = null;
                Object o = this.fVidToVStepMap.get(vmd.getValidatorId());
                if (o != null) {
                    validatorStep = (ReconcileStepForValidator)o;
                } else {
                    IValidator validator = vmd.createValidator();
                    validatorStep = new ReconcileStepForValidator(validator, validatorScope);
                    validatorStep.setInputModel(new DocumentAdapter(doc));
                    this.fVidToVStepMap.put(vmd.getValidatorId(), validatorStep);
                }
                if (!this.fTotalScopeValidatorsAlreadyRun.contains(vmd)) {
                    annotationsToAdd.addAll(Arrays.asList(validatorStep.reconcile(dr, (IRegion)dr)));
                    stepsRanOnThisDirtyRegion.add(validatorStep);
                    if (validatorScope == 0) {
                        this.fTotalScopeValidatorsAlreadyRun.add(vmd);
                    }
                }
            }
            ++i;
        }
        TemporaryAnnotation[] annotationsToRemove = this.getAnnotationsToRemove(dr, stepsRanOnThisDirtyRegion);
        if (annotationsToRemove.length + annotationsToAdd.size() > 0) {
            this.smartProcess(annotationsToRemove, annotationsToAdd.toArray(new IReconcileResult[annotationsToAdd.size()]));
        }
    }

    public void release() {
        super.release();
        ValPrefManagerGlobal.getDefault().removeListener(this.fValChangedListener);
        ValPrefManagerProject.removeListener((IValChangedListener)this.fValChangedListener);
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            if (!(step instanceof IReleasable)) continue;
            ((IReleasable)step).release();
        }
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        Iterator it = this.fVidToVStepMap.values().iterator();
        IReconcileStep step = null;
        while (it.hasNext()) {
            step = (IReconcileStep)it.next();
            step.setInputModel((IReconcilableModel)new DocumentAdapter(document));
        }
    }

    /*
     * Exception decompiling
     */
    private IFile getFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 101->104)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void getDisabledValidators(IFile file, Set disabledValsBySourceId, Set disabledValsByClass) {
        if (file != null) {
            Iterator it = ValidationFramework.getDefault().getDisabledValidatorsFor((IResource)file).iterator();
            while (it.hasNext()) {
                Validator v = (Validator)it.next();
                Validator.V1 v1 = v.asV1Validator();
                if (v1 != null) {
                    disabledValsByClass.add(v1.getId());
                    continue;
                }
                if (v.getSourceId() == null) continue;
                String[] sourceIDs = StringUtils.unpack((String)v.getSourceId());
                disabledValsBySourceId.addAll(Arrays.asList(sourceIDs));
            }
        }
    }

    private static boolean areAllValidatorsSuspended(IFile file) {
        MutableWorkspaceSettings workspaceSettings = null;
        try {
            workspaceSettings = ValidationFramework.getDefault().getWorkspaceSettings();
        }
        catch (InvocationTargetException e) {
            Logger.logException("Could not get global validation settings", e);
        }
        MutableProjectSettings projSettings = ValidationFramework.getDefault().getProjectSettings(file.getProject());
        return workspaceSettings != null && workspaceSettings.getSuspend() || ValidationFramework.getDefault().isSuspended() || ValidationFramework.getDefault().isSuspended(file.getProject()) || (workspaceSettings == null || workspaceSettings.getOverride()) && projSettings.getOverride() && projSettings.getSuspend();
    }

    private class ValChangedListener
    implements IValChangedListener {
        private ValChangedListener() {
        }

        public void validatorsForProjectChanged(IProject project, boolean configSettingChanged) {
            if (configSettingChanged) {
                IFile file = ValidatorStrategy.this.getFile();
                if (project == null || file.getProject() == project) {
                    HashSet disabledValsBySourceId = new HashSet(20);
                    HashSet disabledValsByClass = new HashSet(20);
                    ValidatorStrategy.getDisabledValidators(file, disabledValsBySourceId, disabledValsByClass);
                    ValidatorMetaData vmd = null;
                    HashSet disabledSteps = new HashSet();
                    int i = 0;
                    while (i < ValidatorStrategy.this.fMetaData.size() && !ValidatorStrategy.this.isCanceled()) {
                        Object step;
                        vmd = (ValidatorMetaData)ValidatorStrategy.this.fMetaData.get(i);
                        if ((ValidatorStrategy.areAllValidatorsSuspended(file) || disabledValsBySourceId.contains(vmd.getValidatorId()) || disabledValsByClass.contains(vmd.getValidatorClass())) && (step = ValidatorStrategy.this.fVidToVStepMap.get(vmd.getValidatorId())) != null) {
                            disabledSteps.add(step);
                        }
                        ++i;
                    }
                    IAnnotationModel annoModel = ValidatorStrategy.this.getAnnotationModel();
                    Iterator iter = annoModel.getAnnotationIterator();
                    while (iter.hasNext()) {
                        ReconcileAnnotationKey key;
                        IReconcileStep step;
                        TemporaryAnnotation tempAnno;
                        Annotation anno = (Annotation)iter.next();
                        if (!(anno instanceof TemporaryAnnotation) || !((tempAnno = (TemporaryAnnotation)anno).getKey() instanceof ReconcileAnnotationKey) || !disabledSteps.contains(step = (key = (ReconcileAnnotationKey)tempAnno.getKey()).getStep())) continue;
                        annoModel.removeAnnotation(anno);
                    }
                }
            }
        }
    }
}

