/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.details.JpaDetailsPage;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.Tracing;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.views.AbstractJpaView;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaDetailsView
extends AbstractJpaView {
    private JpaDetailsPage<JpaStructureNode> currentPage;
    private JpaSelection currentSelection;
    private Map<Object, JpaDetailsPage<? extends JpaStructureNode>> detailsPages;

    public JpaDetailsView() {
        super(JptUiMessages.JpaDetailsView_viewNotAvailable);
    }

    private JpaDetailsPage<? extends JpaStructureNode> buildDetailsPage(JpaStructureNode structureNode) {
        JpaDetailsProvider detailsProvider = this.getDetailsProvider(structureNode);
        if (detailsProvider == null) {
            return null;
        }
        String id = structureNode.getId();
        Composite container = this.getWidgetFactory().createComposite((Composite)this.getPageBook());
        container.setLayout((Layout)new FillLayout(256));
        JpaDetailsPage<? extends JpaStructureNode> page = detailsProvider.buildDetailsPage(container, id, this.getWidgetFactory());
        if (page != null) {
            this.detailsPages.put(id, page);
        }
        return page;
    }

    public void dispose() {
        this.detailsPages.clear();
        this.currentSelection = JpaSelection.NULL_SELECTION;
        this.currentPage = null;
        super.dispose();
    }

    private JpaDetailsPage<? extends JpaStructureNode> getDetailsPage(JpaStructureNode structureNode) {
        if (this.detailsPages.containsKey(structureNode.getId())) {
            JpaDetailsPage<? extends JpaStructureNode> page = this.detailsPages.get(structureNode.getId());
            if (page != null && page.getControl().isDisposed()) {
                this.detailsPages.remove(structureNode.getId());
            } else {
                return page;
            }
        }
        return this.buildDetailsPage(structureNode);
    }

    private JpaDetailsProvider getDetailsProvider(JpaStructureNode structureNode) {
        String platformId = structureNode.getJpaProject().getJpaPlatform().getId();
        JpaPlatformUi jpaPlatformUI = JpaPlatformUiRegistry.instance().jpaPlatform(platformId);
        return jpaPlatformUI.detailsProvider(structureNode);
    }

    public JpaSelection getSelection() {
        return this.currentSelection;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.currentSelection = JpaSelection.NULL_SELECTION;
        this.detailsPages = new HashMap<Object, JpaDetailsPage<? extends JpaStructureNode>>();
    }

    private void log(String message) {
        if (Tracing.booleanDebugOption("/debug/ui/detailsView")) {
            Tracing.log(message);
        }
    }

    @Override
    public void select(JpaSelection jpaSelection) {
        if (jpaSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = jpaSelection;
        if (jpaSelection != JpaSelection.NULL_SELECTION) {
            JpaStructureNode newNode = jpaSelection.getSelectedNode();
            JpaDetailsPage<? extends JpaStructureNode> newPage = this.getDetailsPage(newNode);
            this.setCurrentPage(newPage);
        } else {
            this.setCurrentPage(null);
        }
    }

    private void setCurrentPage(JpaDetailsPage<? extends JpaStructureNode> page) {
        if (this.currentPage != null) {
            try {
                this.log("JpaDetailsView.setCurrentPage() : disposing of current page");
                this.currentPage.setSubject(null);
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
            }
        }
        JpaDetailsPage<? extends JpaStructureNode> newPage = page;
        if (page != null) {
            try {
                this.log("JpaDetailsView.setCurrentPage() : populating new page");
                newPage.setSubject((JpaStructureNode)this.currentSelection.getSelectedNode());
            }
            catch (Exception e) {
                page = null;
                JptUiPlugin.log(e);
            }
        } else {
            this.log("JpaDetailsView.setCurrentPage() : No page to populate");
        }
        if (newPage != null && this.currentPage == newPage) {
            return;
        }
        this.currentPage = newPage;
        if (page == null) {
            this.showDefaultPage();
        } else {
            this.showPage(page.getControl());
        }
    }
}

