/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalComposite
extends AbstractFormPane<Nullable> {
    public OptionalComposite(AbstractFormPane<? extends Nullable> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private WritablePropertyValueModel<Boolean> buildOptionalHolder() {
        return new PropertyAspectAdapter<Nullable, Boolean>(this.getSubjectHolder(), new String[]{"specifiedOptionalProperty"}){

            protected Boolean buildValue_() {
                return ((Nullable)this.subject).getSpecifiedOptional();
            }

            protected void setValue_(Boolean value) {
                ((Nullable)this.subject).setSpecifiedOptional(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildOptionalStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildOptionalHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (OptionalComposite.this.subject() != null && value == null && (defaultValue = ((Nullable)OptionalComposite.this.subject()).getDefaultOptional()) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)JptUiMappingsMessages.BasicGeneralSection_optionalLabelDefault, (Object)defaultStringValue);
                }
                return JptUiMappingsMessages.BasicGeneralSection_optionalLabel;
            }
        };
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.buildTriStateCheckBoxWithDefault(container, JptUiMappingsMessages.BasicGeneralSection_optionalLabel, this.buildOptionalHolder(), this.buildOptionalStringHolder(), "org.eclipse.jpt.ui.mapping_optional");
    }
}

