/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.projection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.projection.ProjectionAnnotationModelChanges;

class ProjectionViewerInformation {
    private ProjectionAnnotationModel fProjectionAnnotationModel;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener;
    private boolean fIsDocumentChanging = false;
    private List fQueuedAnnotationChanges;

    public ProjectionViewerInformation(ProjectionViewer viewer) {
        this.fDocument = viewer.getDocument();
        this.fProjectionAnnotationModel = viewer.getProjectionAnnotationModel();
    }

    IDocument getDocument() {
        return this.fDocument;
    }

    private List getQueuedAnnotationChanges() {
        if (this.fQueuedAnnotationChanges == null) {
            this.fQueuedAnnotationChanges = new ArrayList();
        }
        return this.fQueuedAnnotationChanges;
    }

    void setIsDocumentChanging(boolean changing) {
        this.fIsDocumentChanging = changing;
    }

    private boolean isDocumentChanging() {
        return this.fIsDocumentChanging;
    }

    void applyAnnotationModelChanges() {
        List queuedChanges = this.getQueuedAnnotationChanges();
        while (!queuedChanges.isEmpty()) {
            ProjectionAnnotationModelChanges changes = (ProjectionAnnotationModelChanges)queuedChanges.remove(0);
            try {
                this.fProjectionAnnotationModel.modifyAnnotations(changes.getDeletions(), changes.getAdditions(), changes.getModifications());
            }
            catch (Exception e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
    }

    boolean hasChangesQueued() {
        return !this.getQueuedAnnotationChanges().isEmpty();
    }

    public void queueAnnotationModelChanges(ProjectionAnnotationModelChanges newChange) {
        this.getQueuedAnnotationChanges().add(newChange);
        if (!this.isDocumentChanging()) {
            this.applyAnnotationModelChanges();
        }
    }

    public void initialize() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(this);
        }
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fQueuedAnnotationChanges != null) {
            this.fQueuedAnnotationChanges.clear();
            this.fQueuedAnnotationChanges = null;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private ProjectionViewerInformation fInfo;

        public DocumentListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (this.fInfo.getDocument() == document) {
                this.fInfo.setIsDocumentChanging(true);
            }
        }

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (document instanceof IDocumentExtension && this.fInfo.getDocument() == document && this.fInfo.hasChangesQueued()) {
                ((IDocumentExtension)document).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener(this.fInfo));
            }
        }
    }

    private class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        private ProjectionViewerInformation fInfo;

        public PostDocumentChangedListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void perform(IDocument document, IDocumentListener owner) {
            this.fInfo.applyAnnotationModelChanges();
            this.fInfo.setIsDocumentChanging(false);
        }
    }
}

