/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDAttributeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDMapFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDAttributeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDFragment;

public abstract class XSDMapFragment
extends XSDFragment
implements IXSDMapFragment {
    private XSDToFragmentController controller_;
    private Vector fragmentsOrder_;
    private Hashtable fragments_;
    private Hashtable attributeFragments_;

    public XSDMapFragment(String id, String name, XSDToFragmentConfiguration config, XSDToFragmentController controller) {
        super(id, name, config);
        this.controller_ = controller;
        this.fragmentsOrder_ = new Vector();
        this.fragments_ = new Hashtable();
        this.attributeFragments_ = new Hashtable();
    }

    public boolean processParameterValues(MultipartFormDataParser parser) throws MultipartFormDataException {
        boolean valuesValid = true;
        String[] params = parser.getParameterValues(this.getID());
        Vector<IXSDFragment> frags = new Vector<IXSDFragment>();
        Vector<IXSDAttributeFragment> attfrags = new Vector<IXSDAttributeFragment>();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (params[i] != null) {
                    IXSDFragment frag = this.getFragment(params[i]);
                    if (frag != null) {
                        frags.add(frag);
                        if (!frag.processParameterValues(parser)) {
                            valuesValid = false;
                        }
                    } else {
                        IXSDAttributeFragment afrag = this.getAttributeFragment(params[i]);
                        if (afrag != null) {
                            attfrags.add(afrag);
                            if (!afrag.processParameterValues(parser)) {
                                valuesValid = false;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        this.removeAllFragments();
        this.removeAllAttributeFragments();
        this.addAttributeFragments(attfrags);
        this.addFragments(frags);
        return valuesValid;
    }

    public void setParameterValues(String paramKey, String[] params) {
        IXSDFragment frag = this.getFragment(paramKey);
        if (frag != null) {
            frag.setParameterValues(paramKey, params);
        }
    }

    public String[] getParameterValues(String paramKey) {
        IXSDFragment frag = this.getFragment(paramKey);
        return frag != null ? frag.getParameterValues(paramKey) : null;
    }

    public boolean validateAllParameterValues() {
        IXSDFragment[] fragments = this.getAllFragments();
        int i = 0;
        while (i < fragments.length) {
            if (!fragments[i].validateAllParameterValues()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean validateParameterValues(String paramKey) {
        IXSDFragment frag = this.getFragment(paramKey);
        return frag != null ? frag.validateParameterValues(paramKey) : true;
    }

    public boolean validateParameterValue(String paramKey, int paramIndex) {
        IXSDFragment frag = this.getFragment(paramKey);
        return frag != null ? frag.validateParameterValue(paramKey, paramIndex) : true;
    }

    public void setXSDToFragmentController(XSDToFragmentController controller) {
        this.controller_ = controller;
    }

    public XSDToFragmentController getXSDToFragmentController() {
        return this.controller_;
    }

    protected void addFragment(String id, IXSDFragment frag) {
        this.addFragment(id, frag, true);
    }

    protected void addFragments(String[] id, IXSDFragment[] frags) {
        this.addFragments(id, frags, true);
    }

    protected void addFragment(IXSDFragment frag) {
        this.addFragment(frag, true);
    }

    protected void addFragments(IXSDFragment[] frags) {
        this.addFragments(frags, true);
    }

    protected void addFragments(Vector frags) {
        this.addFragments(frags, true);
    }

    protected void addFragment(String id, IXSDFragment frag, boolean addToController) {
        this.fragmentsOrder_.add(id);
        this.fragments_.put(id, frag);
        this.controller_.addToCache(id, frag);
    }

    protected void addAttributeFragment(String id, IXSDFragment frag) {
        this.attributeFragments_.put(id, frag);
        this.controller_.addToCache(id, frag);
    }

    public IXSDAttributeFragment[] getAllAttributeFragments() {
        IXSDAttributeFragment[] fragments = new XSDAttributeFragment[this.attributeFragments_.size()];
        Iterator it = this.attributeFragments_.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            fragments[i] = (IXSDAttributeFragment)it.next();
            ++i;
        }
        return fragments;
    }

    protected void addFragments(String[] id, IXSDFragment[] frags, boolean addToController) {
        int i = 0;
        while (i < id.length && i < frags.length) {
            this.addFragment(id[i], frags[i], addToController);
            ++i;
        }
    }

    protected void addFragment(IXSDFragment frag, boolean addToController) {
        this.addFragment(frag.getID(), frag, addToController);
    }

    protected void addFragments(IXSDFragment[] frags, boolean addToController) {
        int i = 0;
        while (i < frags.length) {
            this.addFragment(frags[i].getID(), frags[i], addToController);
            ++i;
        }
    }

    protected void addFragments(Vector frags, boolean addToController) {
        for (Object obj : frags) {
            if (!(obj instanceof IXSDFragment)) continue;
            IXSDFragment frag = (IXSDFragment)obj;
            this.addFragment(frag.getID(), frag, addToController);
        }
    }

    protected void addAttributeFragments(Vector frags) {
        for (Object obj : frags) {
            if (!(obj instanceof IXSDAttributeFragment)) continue;
            IXSDAttributeFragment frag = (IXSDAttributeFragment)obj;
            this.addAttributeFragment(frag.getID(), frag);
        }
    }

    public String[] getFragmentsOrder() {
        String[] fragmentsOrder = new String[this.fragmentsOrder_.size()];
        int i = 0;
        while (i < fragmentsOrder.length) {
            fragmentsOrder[i] = (String)this.fragmentsOrder_.get(i);
            ++i;
        }
        return fragmentsOrder;
    }

    protected boolean setFragmentsOrder(String[] fragmentsOrder) {
        if (fragmentsOrder.length != this.fragmentsOrder_.size()) {
            return false;
        }
        Vector fragmentsOrderCopy = new Vector(this.fragmentsOrder_);
        int i = 0;
        while (i < fragmentsOrder.length) {
            if (!fragmentsOrderCopy.remove(fragmentsOrder[i])) {
                return false;
            }
            ++i;
        }
        this.fragmentsOrder_.clear();
        int j = 0;
        while (j < fragmentsOrder.length) {
            this.fragmentsOrder_.add(fragmentsOrder[j]);
            ++j;
        }
        return true;
    }

    public IXSDAttributeFragment getAttributeFragment(String id) {
        return (IXSDAttributeFragment)this.attributeFragments_.get(id);
    }

    public IXSDFragment getFragment(String id) {
        return (IXSDFragment)this.fragments_.get(id);
    }

    public IXSDFragment[] getFragments(String[] ids) {
        IXSDFragment[] frags = new IXSDFragment[ids.length];
        int i = 0;
        while (i < frags.length) {
            frags[i] = this.getFragment(ids[i]);
            ++i;
        }
        return frags;
    }

    public IXSDFragment[] getAllFragments() {
        IXSDFragment[] fragments = new IXSDFragment[this.fragmentsOrder_.size()];
        int i = 0;
        while (i < this.fragmentsOrder_.size()) {
            fragments[i] = this.getFragment((String)this.fragmentsOrder_.get(i));
            ++i;
        }
        return fragments;
    }

    protected void removeFragment(String id) {
        this.removeFragment(id, true);
    }

    protected void removeFragments(String[] ids) {
        this.removeFragments(ids, true);
    }

    protected void removeAllFragments() {
        this.removeAllFragments(true);
    }

    protected void removeFragment(String id, boolean removeFromController) {
        this.fragmentsOrder_.remove(id);
        this.fragments_.remove(id);
        if (removeFromController) {
            this.controller_.removeFromCache(id);
        }
    }

    protected void removeFragments(String[] ids, boolean removeFromController) {
        int i = 0;
        while (i < ids.length) {
            this.removeFragment(ids[i], removeFromController);
            ++i;
        }
    }

    protected void removeAllFragments(boolean removeFromController) {
        if (removeFromController) {
            Enumeration ids = this.fragments_.keys();
            while (ids.hasMoreElements()) {
                String id = (String)ids.nextElement();
                this.controller_.removeFromCache(id);
            }
        }
        this.fragmentsOrder_.clear();
        this.fragments_.clear();
    }

    protected void removeAllAttributeFragments() {
        Enumeration ids = this.attributeFragments_.keys();
        while (ids.hasMoreElements()) {
            String id = (String)ids.nextElement();
            this.controller_.removeFromCache(id);
        }
        this.attributeFragments_.clear();
    }
}

