/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.JsGlobalScopeContainerDescriptor;

public class JsGlobalScopeContainerSelectionPage
extends WizardPage {
    private static final String DIALOGSTORE_SECTION = "JsGlobalScopeContainerSelectionPage";
    private static final String DIALOGSTORE_CONTAINER_IDX = "index";
    private ListViewer fListViewer;
    private JsGlobalScopeContainerDescriptor[] fContainers;
    private IDialogSettings fDialogSettings;

    protected JsGlobalScopeContainerSelectionPage(JsGlobalScopeContainerDescriptor[] containerPages) {
        super("JsGlobalScopeContainerWizardPage");
        this.setTitle(NewWizardMessages.JsGlobalScopeContainerSelectionPage_title);
        this.setDescription(NewWizardMessages.JsGlobalScopeContainerSelectionPage_description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainers = containerPages;
        IDialogSettings settings = JavaScriptPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(DIALOGSTORE_SECTION);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(DIALOGSTORE_SECTION);
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, 0);
        }
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.fListViewer = new ListViewer(parent, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new JsGlobalScopeContainerLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fListViewer.setComparator(new ViewerComparator());
        this.fListViewer.setInput(Arrays.asList(this.fContainers));
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JsGlobalScopeContainerSelectionPage.this.validatePage();
            }
        });
        this.fListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JsGlobalScopeContainerSelectionPage.this.doDoubleClick();
            }
        });
        int selectionIndex = this.fDialogSettings.getInt(DIALOGSTORE_CONTAINER_IDX);
        if (selectionIndex >= this.fContainers.length) {
            selectionIndex = 0;
        }
        this.fListViewer.getList().select(selectionIndex);
        this.validatePage();
        this.setControl((Control)this.fListViewer.getList());
        Dialog.applyDialogFont((Control)this.fListViewer.getList());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.jsdt.ui.bp_select_classpath_container");
    }

    private void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    public JsGlobalScopeContainerDescriptor getSelected() {
        if (this.fListViewer != null) {
            ISelection selection = this.fListViewer.getSelection();
            return (JsGlobalScopeContainerDescriptor)SelectionUtil.getSingleElement(selection);
        }
        return null;
    }

    public JsGlobalScopeContainerDescriptor[] getContainers() {
        return this.fContainers;
    }

    protected void doDoubleClick() {
        if (this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (!visible && this.fListViewer != null) {
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, this.fListViewer.getList().getSelectionIndex());
        }
        super.setVisible(visible);
    }

    private static class JsGlobalScopeContainerLabelProvider
    extends LabelProvider {
        private JsGlobalScopeContainerLabelProvider() {
        }

        public String getText(Object element) {
            return ((JsGlobalScopeContainerDescriptor)element).getName();
        }
    }
}

