/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.util;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

abstract class TableViewerImpl
implements TraverseListener {
    boolean fIsActivating = false;
    private boolean fSingleClickCellSelect = false;
    private CellEditor fCellEditor;
    private CellEditor[] fCellEditors;
    private ICellModifier fCellModifier;
    private String[] fColumnProperties;
    private Item fTableItem;
    private int fColumnNumber;
    private ICellEditorListener fCellEditorListener;
    protected Table fTable = null;

    TableViewerImpl(Table table) {
        this.fTable = table;
        this.initCellEditorListener();
    }

    private void activateCellEditor() {
        String property;
        Object element;
        if (this.fCellEditors != null && this.fCellEditors[this.fColumnNumber] != null && this.fCellModifier != null && this.fCellModifier.canModify(element = this.fTableItem.getData(), property = this.fColumnProperties[this.fColumnNumber])) {
            this.fCellEditor = this.fCellEditors[this.fColumnNumber];
            this.fCellEditor.addListener(this.fCellEditorListener);
            Object value = this.fCellModifier.getValue(element, property);
            this.fCellEditor.setValue(value);
            Control control = this.fCellEditor.getControl();
            this.fCellEditor.activate();
            if (control != null) {
                this.setLayoutData(this.fCellEditor.getLayoutData());
                this.setEditor(control, this.fTableItem, this.fColumnNumber);
                this.fCellEditor.setFocus();
            }
        }
    }

    private void activateCellEditor(MouseEvent event) {
        if (this.fTableItem == null || this.fTableItem.isDisposed()) {
            return;
        }
        int columns = this.getColumnCount();
        int columnToEdit = -1;
        Rectangle bounds = null;
        int i = 0;
        while (i < columns) {
            bounds = this.getBounds(this.fTableItem, i);
            if (bounds.contains(event.x, event.y)) {
                columnToEdit = i;
                break;
            }
            ++i;
        }
        if (columnToEdit == -1 || bounds == null) {
            return;
        }
        this.fColumnNumber = columnToEdit;
        this.activateCellEditor();
    }

    public void activateFirstCellEditor() {
        if (this.fCellEditors != null) {
            int columnNumber = -1;
            int i = 0;
            while (i < this.fCellEditors.length) {
                if (this.fCellEditors[i] != null && this.getCellModifier().canModify(this.fTableItem.getData(), (String)this.getColumnProperties()[i])) {
                    columnNumber = i;
                    break;
                }
                ++i;
            }
            if (columnNumber > -1 && this.fCellModifier != null) {
                this.fColumnNumber = columnNumber;
                this.activateCellEditor();
            }
        }
    }

    public void applyEditorValue() {
        CellEditor c = this.fCellEditor;
        if (c != null) {
            this.fCellEditor = null;
            Item t = this.fTableItem;
            if (t != null && !t.isDisposed()) {
                this.saveEditorValue(c, t);
            }
            this.setEditor(null, null, 0);
            c.removeListener(this.fCellEditorListener);
            c.deactivate();
        }
    }

    public void cancelEditing() {
        if (this.fCellEditor != null) {
            this.setEditor(null, null, 0);
            this.fCellEditor.removeListener(this.fCellEditorListener);
            this.fCellEditor.deactivate();
            this.fCellEditor = null;
        }
    }

    public void editElement(Object element, int column) {
        if (this.fCellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(element), true);
        Item[] selection = this.getSelection();
        if (selection.length != 1) {
            return;
        }
        this.fTableItem = selection[0];
        this.showSelection();
        this.fColumnNumber = column;
        this.activateCellEditor();
    }

    abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this.fCellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.fCellModifier;
    }

    abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this.fColumnProperties;
    }

    abstract Item[] getSelection();

    public void handleMouseDoubleClick(MouseEvent event) {
    }

    public void handleMouseDown(MouseEvent event) {
        Item[] items;
        if (event.button != 1) {
            return;
        }
        boolean wasActivated = this.isCellEditorActive();
        if (wasActivated) {
            this.applyEditorValue();
        }
        if ((items = this.getSelection()).length != 1) {
            this.fTableItem = null;
            return;
        }
        if (this.fTableItem != items[0]) {
            this.fTableItem = items[0];
            if (!this.fSingleClickCellSelect) {
                return;
            }
        }
        if (this.fIsActivating || wasActivated) {
            return;
        }
        this.fIsActivating = true;
        this.postActivation(event);
    }

    private void handleRightArrow(TraverseEvent e) {
    }

    private void handleDownArrow(TraverseEvent e) {
        int row = this.fTable.indexOf((TableItem)this.fTableItem);
        if (this.fCellEditors != null && this.fCellModifier != null && row < this.fTable.getItemCount() - 1) {
            String property = null;
            TableItem next = this.fTable.getItem(row + 1);
            Object element = next.getData();
            if (this.fCellEditors[this.fColumnNumber] != null && this.fCellModifier.canModify(element, property = this.fColumnProperties[this.fColumnNumber])) {
                this.applyEditorValue();
                this.fTableItem = next;
                this.setSelection(new StructuredSelection(next.getData()), true);
                this.fTable.select(row + 1);
                this.showSelection();
                e.doit = false;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    private void handleLeftArrow(TraverseEvent e) {
    }

    private void handleUpArrow(TraverseEvent e) {
        int row = this.fTable.indexOf((TableItem)this.fTableItem);
        if (this.fCellEditors != null && this.fCellModifier != null && row > 0) {
            String property = null;
            TableItem previous = this.fTable.getItem(row - 1);
            Object element = previous.getData();
            if (this.fCellEditors[this.fColumnNumber] != null && this.fCellModifier.canModify(element, property = this.fColumnProperties[this.fColumnNumber])) {
                this.applyEditorValue();
                this.fTableItem = previous;
                this.setSelection(new StructuredSelection(previous.getData()), true);
                this.fTable.select(row - 1);
                this.showSelection();
                e.doit = false;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    private void handleTabNext(TraverseEvent e) {
        if (this.fCellEditors != null && this.fCellModifier != null && this.fCellEditors.length > this.fColumnNumber + 1) {
            int start = this.fColumnNumber + 1;
            String property = null;
            Object element = this.fTableItem.getData();
            int i = start;
            while (i <= this.fCellEditors.length) {
                if (this.fCellEditors[i] != null && this.fCellModifier.canModify(element, property = this.fColumnProperties[i])) {
                    this.fColumnNumber = i;
                    e.doit = false;
                    break;
                }
                ++i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        } else if (this.fCellEditors != null && this.fCellModifier != null && this.fCellEditors.length == this.fColumnNumber + 1) {
            this.fColumnNumber = 0;
            this.handleDownArrow(e);
        }
    }

    private void handleTabPrevious(TraverseEvent e) {
        if (this.fCellEditors != null && this.fCellModifier != null && this.fColumnNumber > 0) {
            int start = this.fCellEditors.length >= this.fColumnNumber - 1 ? this.fColumnNumber - 1 : this.fCellEditors.length - 1;
            String property = null;
            Object element = this.fTableItem.getData();
            int i = start;
            while (i >= 0) {
                if (this.fCellEditors[i] != null && this.fCellModifier.canModify(element, property = this.fColumnProperties[i])) {
                    this.fColumnNumber = i;
                    e.doit = false;
                    break;
                }
                --i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        } else if (this.fCellEditors != null && this.fCellModifier != null && this.fColumnNumber == 0) {
            this.fColumnNumber = this.getColumnCount() - 1;
            this.handleUpArrow(e);
        }
    }

    private void initCellEditorListener() {
        this.fCellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                TableViewerImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                TableViewerImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.fCellEditor != null;
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16) {
            this.applyEditorValue();
            this.handleTabNext(e);
        } else if (e.detail == 8) {
            this.applyEditorValue();
            this.handleTabPrevious(e);
        } else if (e.keyCode == 0x1000004) {
            this.handleRightArrow(e);
        } else if (e.keyCode == 0x1000003) {
            this.handleLeftArrow(e);
        } else if (e.keyCode == 0x1000001) {
            this.handleUpArrow(e);
        } else if (e.keyCode == 0x1000002) {
            this.handleDownArrow(e);
        }
    }

    private void postActivation(final MouseEvent event) {
        if (!this.fIsActivating) {
            return;
        }
        new Thread(){

            public void run() {
                if (TableViewerImpl.this.fIsActivating) {
                    TableViewerImpl.this.getDisplay().asyncExec(new Runnable(this, event){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ MouseEvent val$event;
                        {
                            this.this$1 = var1_1;
                            this.val$event = mouseEvent;
                        }

                        public void run() {
                            TableViewerImpl.access$1(2.access$0(this.this$1), this.val$event);
                            2.access$0(this.this$1).fIsActivating = false;
                        }
                    });
                }
            }

            static /* synthetic */ TableViewerImpl access$0(2 var0) {
                return var0.TableViewerImpl.this;
            }
        }.start();
    }

    private Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    private void saveEditorValue(CellEditor cellEditor, Item tableItem) {
        if (this.fCellModifier != null) {
            cellEditor.isValueValid();
            String property = null;
            if (this.fColumnProperties != null && this.fColumnNumber < this.fColumnProperties.length) {
                property = this.fColumnProperties[this.fColumnNumber];
            }
            this.fCellModifier.modify((Object)tableItem, property, cellEditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.fCellEditors = editors;
        int i = 0;
        while (i < editors.length) {
            Control control;
            if (editors[i] != null && (control = editors[i].getControl()) != null) {
                control.addTraverseListener((TraverseListener)this);
            }
            ++i;
        }
    }

    public void setCellModifier(ICellModifier modifier) {
        this.fCellModifier = modifier;
    }

    public void setColumnProperties(String[] columnProperties) {
        this.fColumnProperties = columnProperties;
    }

    abstract void setEditor(Control var1, Item var2, int var3);

    abstract void setLayoutData(CellEditor.LayoutData var1);

    abstract void setSelection(StructuredSelection var1, boolean var2);

    abstract void showSelection();

    public boolean getSingleClickCellSelect() {
        return this.fSingleClickCellSelect;
    }

    public void setSingleClickCellSelect(boolean singleClickCellSelect) {
        this.fSingleClickCellSelect = singleClickCellSelect;
    }

    public void setTableItem(Item item) {
        this.fTableItem = item;
    }

    private void startActivationThread() {
        new Thread(){

            public void run() {
                TableViewerImpl.this.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TableViewerImpl.access$2(4.access$0(this.this$1));
                        4.access$0(this.this$1).fIsActivating = false;
                    }
                });
            }

            static /* synthetic */ TableViewerImpl access$0(4 var0) {
                return var0.TableViewerImpl.this;
            }
        }.start();
    }

    static /* synthetic */ void access$1(TableViewerImpl tableViewerImpl, MouseEvent mouseEvent) {
        tableViewerImpl.activateCellEditor(mouseEvent);
    }

    static /* synthetic */ void access$2(TableViewerImpl tableViewerImpl) {
        tableViewerImpl.activateCellEditor();
    }
}

