/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.Tracing;

public class ValidatorTypeFilter {
    private Class _typeFilterClass;
    private String _mustImplementClass;

    ValidatorTypeFilter() {
    }

    ValidatorTypeFilter(String mustImplementClass) {
        this.setMustImplementClass(mustImplementClass);
    }

    String getMustImplementClass() {
        return this._mustImplementClass;
    }

    Class getTypeFilterClass() {
        return this._typeFilterClass;
    }

    public boolean isApplicableType(IResource resource) {
        if (this._typeFilterClass == null) {
            return true;
        }
        return this.isInstance(resource.getClass(), this._typeFilterClass);
    }

    boolean isInstance(Class objectClass, Class filterClass) {
        Class cl = objectClass;
        while (cl != null) {
            if (cl.getName().equals(filterClass.getName())) {
                return true;
            }
            int i = 0;
            Class<?>[] clInterfaces = cl.getInterfaces();
            if (i < clInterfaces.length) {
                if (clInterfaces[i].getName().equals(filterClass.getName())) {
                    return true;
                }
                return this.isInstance(clInterfaces[i], filterClass);
            }
            cl = cl.getSuperclass();
        }
        return false;
    }

    void setMustImplementClass(String className) {
        this._mustImplementClass = className;
    }

    void setTypeFilter(String filter) {
        Class<?> filterClass = null;
        Class<?> mustImplementClass = null;
        if (filter == null) {
            this._typeFilterClass = null;
            return;
        }
        try {
            filterClass = Class.forName(filter);
            if (this.getMustImplementClass() != null && !this.isInstance(filterClass, mustImplementClass = Class.forName(this.getMustImplementClass()))) {
                this._typeFilterClass = null;
                if (Tracing.isLogging()) {
                    String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_INVALID_TYPE_FILTER"), filter, this.getMustImplementClass());
                    Tracing.log("ValidatorTypeFilter-01: ", result);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._typeFilterClass = null;
            if (Tracing.isLogging()) {
                Tracing.log("ValidatorTypeFilter-02: The class named " + filter + " cannot be instantiated because it does not exist. Check the spelling of the name, " + "in the validator's plugin.xml contribution, and try restarting eclipse again.");
            }
            return;
        }
        this._typeFilterClass = filterClass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TypeFilter:");
        buffer.append("     _typeFilterClass = " + this._typeFilterClass.getName());
        buffer.append("     _mustImplementClass = " + this._mustImplementClass);
        return buffer.toString();
    }
}

