/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.util;

import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControlSwitcher {
    private PageBook pageBook;
    private Transformer<?, Control> paneTransformer;

    public <T> ControlSwitcher(PropertyValueModel<? extends T> switchHolder, Transformer<T, Control> paneTransformer, PageBook pageBook) {
        this.initialize(switchHolder, paneTransformer, pageBook);
    }

    private PropertyChangeListener buildPropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildPropertyChangeListener_());
    }

    private PropertyChangeListener buildPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                ControlSwitcher.this.switchPanes(e.getNewValue());
            }
        };
    }

    private void initialize(PropertyValueModel<?> switchHolder, Transformer<?, Control> paneTransformer, PageBook pageBook) {
        this.pageBook = pageBook;
        this.paneTransformer = paneTransformer;
        switchHolder.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        this.switchPanes(switchHolder.getValue());
    }

    private void switchPanes(Object value) {
        boolean visible;
        if (this.pageBook.isDisposed()) {
            return;
        }
        Control pane = this.transform(value);
        boolean bl = visible = pane != null;
        if (visible) {
            this.pageBook.showPage(pane);
        } else {
            this.pageBook.showPage((Control)new Label((Composite)this.pageBook, 258));
        }
        if (this.pageBook.isVisible() != visible) {
            this.pageBook.setVisible(visible);
        }
        SWTUtil.reflow((Composite)this.pageBook);
    }

    private Control transform(Object value) {
        return (Control)this.paneTransformer.transform(value);
    }
}

