/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class RefreshStructureJob
extends Job {
    static final boolean DEBUG;
    private static final long UPDATE_DELAY = 250L;
    private final List fRequests;
    List fViewers = new ArrayList(3);

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/refreshStructure");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public RefreshStructureJob() {
        super(XMLUIMessages.refreshoutline_0);
        this.setPriority(30);
        this.setSystem(true);
        this.fRequests = new ArrayList(2);
    }

    private synchronized void addRequest(Node newNodeRequest) {
        int size = this.fRequests.size();
        int i = 0;
        while (i < size) {
            Node existingNodeRequest = (Node)this.fRequests.get(i);
            if (existingNodeRequest.equals(newNodeRequest)) {
                return;
            }
            if (this.contains(existingNodeRequest, newNodeRequest)) {
                return;
            }
            if (this.contains(newNodeRequest, existingNodeRequest)) {
                this.fRequests.set(i, newNodeRequest);
                return;
            }
            ++i;
        }
        this.fRequests.add(newNodeRequest);
    }

    private synchronized void addViewer(StructuredViewer viewer) {
        if (!this.fViewers.contains(viewer)) {
            this.fViewers.add(viewer);
        }
    }

    private boolean contains(Node root, Node possible) {
        if (DEBUG) {
            System.out.println("==============================================================================================================");
            System.out.println("recursive call w/ root: " + root.getNodeName() + " and possible: " + possible);
            System.out.println("--------------------------------------------------------------------------------------------------------------");
        }
        if (root == null) {
            if (DEBUG) {
                System.out.println("returning false: root is null");
            }
            return false;
        }
        if (possible instanceof Document) {
            if (DEBUG) {
                System.out.println("returning false: possible is Document node");
            }
            return false;
        }
        if (root instanceof Document) {
            if (DEBUG) {
                System.out.println("returning true: root is Document node");
            }
            return true;
        }
        Node current = possible;
        while (current != null && current.getNodeType() != 9) {
            if (root.equals(current)) {
                if (DEBUG) {
                    System.out.println("   !!! found: " + possible.getNodeName() + " in subelement of: " + root.getNodeName());
                }
                return true;
            }
            current = current.getParentNode();
        }
        return false;
    }

    private void doRefresh(final Node node, final StructuredViewer[] viewers) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (DEBUG) {
                    System.out.println("refresh on: [" + node.getNodeName() + "]");
                }
                int i = 0;
                while (i < viewers.length) {
                    if (!viewers[i].getControl().isDisposed()) {
                        if (node.getNodeType() == 9) {
                            viewers[i].refresh(true);
                        } else {
                            viewers[i].refresh((Object)node, true);
                        }
                    } else if (DEBUG) {
                        System.out.println("   !!! skipped refreshing disposed viewer: " + viewers[i]);
                    }
                    ++i;
                }
            }
        });
    }

    private synchronized Object[] getRequests() {
        Node[] toRefresh = this.fRequests.toArray(new Node[this.fRequests.size()]);
        this.fRequests.clear();
        StructuredViewer[] viewers = this.fViewers.toArray(new StructuredViewer[this.fViewers.size()]);
        this.fViewers.clear();
        return new Object[]{toRefresh, viewers};
    }

    public void refresh(StructuredViewer viewer, Node node) {
        if (node == null) {
            return;
        }
        this.addViewer(viewer);
        this.addRequest(node);
        this.schedule(250L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            Object[] requests = this.getRequests();
            Node[] nodes = (Node[])requests[0];
            StructuredViewer[] viewers = (StructuredViewer[])requests[1];
            int i = 0;
            while (i < nodes.length) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.doRefresh(nodes[i], viewers);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
        return status;
    }
}

