/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.listeners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.internal.dialogs.ListMessageDialog;
import org.eclipse.jst.j2ee.internal.listeners.IValidateEditListener;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.IValidateEditContext;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidatorPresenter;

public class ValidateEditListener
extends ShellAdapter
implements IValidateEditListener,
IValidateEditContext {
    protected ResourceStateValidator fValidator;
    private boolean fNeedsStateValidation = true;
    private Shell fShell;
    private IWorkbenchPart fPart;
    private boolean fHasReadOnlyFiles = false;
    private boolean firstReadOnlyFileAttempt = true;
    private boolean fMessageUp = false;
    private boolean fIsActivating = false;
    private boolean fIsDeactivating = false;
    private boolean inconsistentResult;
    private boolean inconsistentOverwriteResult;

    public ValidateEditListener() {
        try {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    if (wb == null) {
                        return;
                    }
                    IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                    if (window == null && wb.getWorkbenchWindowCount() > 0) {
                        int i = 0;
                        while (i < wb.getWorkbenchWindows().length) {
                            window = wb.getWorkbenchWindows()[i];
                            if (window != null) break;
                            ++i;
                        }
                    }
                    if (window != null) {
                        ValidateEditListener.this.setShell(window.getShell());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ValidateEditListener(IWorkbenchPart part, ResourceStateValidator aValidator) {
        this.fPart = part;
        this.fValidator = aValidator;
        if (part != null) {
            part.getSite().getPage().addPartListener((IPartListener)this);
        }
        if (this.getShell() != null) {
            this.getShell().addShellListener((ShellListener)this);
        }
    }

    protected Shell getShell() {
        if (this.fShell == null && this.fPart != null && this.fPart.getSite() != null) {
            this.fShell = this.fPart.getSite().getShell();
        }
        return this.fShell;
    }

    public ResourceStateValidator getValidator() {
        return this.fValidator;
    }

    public boolean getNeedsStateValidation() {
        return this.fNeedsStateValidation;
    }

    public void setNeedsStateValidation(boolean needsStateValidation) {
        this.fNeedsStateValidation = needsStateValidation;
    }

    public boolean promptForInconsistentFileRefresh(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.size() == 0) {
            return false;
        }
        ArrayList<String> inconsistentFileNames = new ArrayList<String>();
        int i = 0;
        while (inconsistentFiles.size() > i) {
            Object file = inconsistentFiles.get(i);
            if (file instanceof Resource) {
                IFile aFile = WorkbenchResourceHelper.getFile((Resource)((Resource)file));
                inconsistentFileNames.add(aFile.getFullPath().toOSString());
            } else if (file instanceof IResource) {
                IResource resfile = (IResource)file;
                if (!resfile.exists()) {
                    return false;
                }
                inconsistentFileNames.add(resfile.getFullPath().toOSString());
            }
            ++i;
        }
        final String title = J2EEUIMessages.getResourceString("Inconsistent_Files_3");
        final String message = String.valueOf(J2EEUIMessages.getResourceString("The_following_workspace_files_are_inconsistent_with_the_editor_4")) + J2EEUIMessages.getResourceString("Update_the_editor_with_the_workspace_contents__5");
        final String[] fileNames = inconsistentFileNames.toArray(new String[inconsistentFileNames.size()]);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ValidateEditListener.this.inconsistentResult = ListMessageDialog.openQuestion(ValidateEditListener.this.getShell(), title, message, fileNames);
            }
        });
        return this.inconsistentResult;
    }

    public Object getValidateEditContext() {
        return this.getShell();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this.fPart) {
            this.handleActivation();
        }
    }

    protected void handleActivation() {
        if (this.fIsActivating) {
            return;
        }
        this.fIsActivating = true;
        try {
            try {
                this.fValidator.checkActivation((ResourceStateValidatorPresenter)this);
                this.updatePartReadOnly();
            }
            catch (CoreException coreException) {
                this.fIsActivating = false;
            }
        }
        finally {
            this.fIsActivating = false;
        }
    }

    public void shellActivated(ShellEvent event) {
        this.handleActivation();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.fPart) {
            part.getSite().getPage().removePartListener((IPartListener)this);
        }
        if (this.getShell() != null) {
            this.getShell().removeShellListener((ShellListener)this);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (part == this.fPart) {
            if (this.fIsDeactivating) {
                return;
            }
            this.fIsDeactivating = true;
            try {
                try {
                    this.fValidator.lostActivation((ResourceStateValidatorPresenter)this);
                    this.updatePartReadOnly();
                }
                catch (CoreException coreException) {
                    this.fIsDeactivating = true;
                }
            }
            finally {
                this.fIsDeactivating = true;
            }
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public IStatus validateState() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (this.fShell == null && wb != null && wb.getActiveWorkbenchWindow() != null) {
            this.fShell = wb.getActiveWorkbenchWindow().getShell();
        }
        if (this.fNeedsStateValidation) {
            this.setNeedsStateValidation(false);
            try {
                final IStatus status = this.fValidator.validateState((ResourceStateValidatorPresenter)this);
                if (status.getSeverity() == 4) {
                    this.setNeedsStateValidation(true);
                    if (!this.fMessageUp) {
                        this.fMessageUp = true;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openError((Shell)ValidateEditListener.this.getShell(), (String)J2EEUIMessages.getResourceString("Error_checking_out_files_10"), (String)status.getMessage());
                            }
                        });
                        this.fMessageUp = false;
                    }
                }
                this.fValidator.checkActivation((ResourceStateValidatorPresenter)this);
                this.updatePartReadOnly();
                return status;
            }
            catch (CoreException coreException) {}
        }
        return ResourceStateValidator.OK_STATUS;
    }

    public boolean promptForInconsistentFileOverwrite(List inconsistentFiles) {
        int size = inconsistentFiles.size();
        ArrayList<String> files = new ArrayList<String>();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)inconsistentFiles.get(i);
            files.add(file.getFullPath().toString());
            ++i;
        }
        final String[] items = files.toArray(new String[files.size()]);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ValidateEditListener.this.inconsistentOverwriteResult = ListMessageDialog.openQuestion(ValidateEditListener.this.getShell(), J2EEUIMessages.getResourceString("Inconsistent_files_detected_11"), J2EEUIMessages.getResourceString("The_following_files_are_inconsistent_with_the_file_system._Do_you_want_to_save_and_overwrite_these_files_on_the_file_system__12_WARN_"), items);
            }
        });
        return this.inconsistentOverwriteResult;
    }

    protected boolean checkReadOnly() {
        this.fHasReadOnlyFiles = this.fValidator.checkReadOnly();
        return this.fHasReadOnlyFiles;
    }

    public boolean hasReadOnlyFiles() {
        if (this.firstReadOnlyFileAttempt) {
            this.checkReadOnly();
            this.firstReadOnlyFileAttempt = false;
        }
        return this.fHasReadOnlyFiles;
    }

    protected void updatePartReadOnly() {
        if (!this.getNeedsStateValidation()) {
            this.checkReadOnly();
            this.setNeedsStateValidation(true);
        } else {
            this.firstReadOnlyFileAttempt = true;
        }
    }

    public boolean checkSave() throws CoreException {
        return this.validateState().isOK() && this.getValidator().checkSave((ResourceStateValidatorPresenter)this);
    }

    public void setShell(Shell aShell) {
        this.fShell = aShell;
    }

    public void setEditModel(EditModel anEditModel) {
        this.fValidator = anEditModel;
    }

    public IStatus validateState(EditModel anEditModel) {
        this.setEditModel(anEditModel);
        return this.validateState();
    }
}

