/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.SingleRootStatus;
import org.eclipse.jst.j2ee.project.ISingleRootStatus;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SingleRootUtil {
    public static final int INCLUDE_FIRST_ERROR = 8;
    public static final int INCLUDE_ALL = 7;
    public static final int INCLUDE_ERRORS_AND_WARNINGS = 6;
    public static final int INCLUDE_ERRORS = 4;
    private static final int WARNINGS = 2;
    private static final int INFO = 1;
    private static final int NONE = 0;
    private static String USE_SINGLE_ROOT_PROPERTY = "useSingleRoot";
    private IVirtualComponent component;
    private IPackageFragmentRoot[] cachedSourceContainers;
    private IContainer[] cachedOutputContainers;
    private boolean isSingleJavaOutputNonSource;
    private MultiStatus wrapperStatus;
    private int INCLUDE_FLAG;

    public SingleRootUtil(IVirtualComponent component) {
        this.component = component;
    }

    public boolean isSingleRoot() {
        return this.validateSingleRoot(8).getSeverity() != 4;
    }

    public IStatus validateSingleRoot(int flag) {
        this.INCLUDE_FLAG = flag;
        this.isSingleJavaOutputNonSource = false;
        this.wrapperStatus = null;
        StructureEdit edit = null;
        try {
            IPath sourcePath;
            IResource sourceResource;
            ComponentResource mapping;
            edit = StructureEdit.getStructureEditForRead((IProject)this.getProject());
            if (edit == null || edit.getComponent() == null) {
                this.reportStatus(67);
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            WorkbenchComponent wbComp = edit.getComponent();
            EList resourceMaps = wbComp.getResources();
            EList componentProperties = wbComp.getProperties();
            if (componentProperties != null) {
                for (Property wbProperty : componentProperties) {
                    if (!USE_SINGLE_ROOT_PROPERTY.equals(wbProperty.getName())) continue;
                    boolean useSingleRoot = Boolean.valueOf(wbProperty.getValue());
                    if (useSingleRoot) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    this.reportStatus(81);
                    IStatus iStatus = this.getStatus();
                    return iStatus;
                }
            }
            if (JavaEEProjectUtilities.isEARProject(this.getProject())) {
                this.reportStatus(69);
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            if (this.rootFoldersHaveLinkedContent()) {
                this.reportStatus(70);
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            if (resourceMaps.size() < 1) {
                this.reportStatus(74);
                IStatus iStatus = this.getStatus();
                return iStatus;
            }
            if (resourceMaps.size() == 1 && (mapping = (ComponentResource)resourceMaps.get(0)).getRuntimePath().equals((Object)Path.ROOT) && (sourceResource = this.getProject().findMember(mapping.getSourcePath())) != null && sourceResource.exists() && !this.isSourceContainer(sourcePath = this.getProject().getFullPath().append(mapping.getSourcePath()))) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (this.hasClasspathDependencies(this.component)) {
                this.reportStatus(82);
                if (this.INCLUDE_FLAG == 0) {
                    IStatus iStatus = this.getStatus();
                    return iStatus;
                }
            }
            if (JavaEEProjectUtilities.isDynamicWebProject(this.getProject())) {
                this.validateWebProject((List)resourceMaps);
            } else if (JavaEEProjectUtilities.isEJBProject(this.getProject()) || JavaEEProjectUtilities.isJCAProject(this.getProject()) || JavaEEProjectUtilities.isApplicationClientProject(this.getProject()) || JavaEEProjectUtilities.isUtilityProject(this.getProject())) {
                this.validateProject((List)resourceMaps);
            }
            IStatus iStatus = this.getStatus();
            return iStatus;
        }
        finally {
            this.cachedOutputContainers = null;
            this.cachedSourceContainers = null;
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private void validateProject(List resourceMaps) {
        if (this.isRootResourceMapping(resourceMaps)) {
            IContainer[] javaOutputFolders = this.getJavaOutputFolders();
            if (javaOutputFolders.length == 1) {
                if (!this.isSourceContainer(javaOutputFolders[0].getFullPath())) {
                    this.isSingleJavaOutputNonSource = true;
                    return;
                }
                IPath javaOutputPath = this.getJavaOutputFolders()[0].getProjectRelativePath();
                IContainer[] rootFolders = this.component.getRootFolder().getUnderlyingFolders();
                int i = 0;
                while (i < rootFolders.length) {
                    IPath compRootPath = rootFolders[i].getProjectRelativePath();
                    if (javaOutputPath.equals((Object)compRootPath)) {
                        return;
                    }
                    ++i;
                }
                this.reportStatus(71);
            } else {
                this.reportStatus(68);
            }
        }
    }

    private void validateWebProject(List resourceMaps) {
        if (this.hasDefaultWebResourceMappings(resourceMaps)) {
            if (this.getJavaOutputFolders().length == 1) {
                IPath javaOutputPath = this.getJavaOutputFolders()[0].getProjectRelativePath();
                IPath compRootPath = this.component.getRootFolder().getUnderlyingFolder().getProjectRelativePath();
                if (compRootPath.append("WEB-INF/classes").equals((Object)javaOutputPath)) {
                    return;
                }
                this.reportStatus(72);
            } else {
                this.reportStatus(68);
            }
        }
    }

    public IContainer[] getJavaOutputFolders() {
        if (this.cachedOutputContainers == null) {
            this.cachedOutputContainers = this.getJavaOutputFolders(this.getProject());
        }
        return this.cachedOutputContainers;
    }

    public IContainer[] getJavaOutputFolders(IProject project) {
        if (project == null) {
            return new IContainer[0];
        }
        return J2EEProjectUtilities.getOutputContainers(project);
    }

    private boolean isSourceContainer(IPath path) {
        IPackageFragmentRoot[] srcContainers = this.getSourceContainers();
        int i = 0;
        while (i < srcContainers.length) {
            if (srcContainers[i].getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IPackageFragmentRoot[] getSourceContainers() {
        if (this.cachedSourceContainers == null) {
            this.cachedSourceContainers = J2EEProjectUtilities.getSourceContainers(this.getProject());
        }
        return this.cachedSourceContainers;
    }

    private boolean rootFoldersHaveLinkedContent() {
        if (this.component != null) {
            IContainer[] rootFolders = this.component.getRootFolder().getUnderlyingFolders();
            int i = 0;
            while (i < rootFolders.length) {
                try {
                    boolean hasLinkedContent = this.hasLinkedContent((IResource)rootFolders[i]);
                    if (hasLinkedContent) {
                        return true;
                    }
                }
                catch (CoreException coreEx) {
                    J2EEPlugin.logError(coreEx);
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasLinkedContent(IResource resourceToCheck) throws CoreException {
        if (resourceToCheck != null && resourceToCheck.isAccessible()) {
            if (resourceToCheck.isLinked()) {
                return true;
            }
            switch (resourceToCheck.getType()) {
                case 2: {
                    IResource[] subDirContents = ((IFolder)resourceToCheck).members();
                    int i = 0;
                    while (i < subDirContents.length) {
                        if (this.hasLinkedContent(subDirContents[i])) {
                            return true;
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    return resourceToCheck.isLinked();
                }
            }
        }
        return false;
    }

    private boolean isRootResourceMapping(List resourceMaps) {
        int i = 0;
        while (i < resourceMaps.size()) {
            IResource sourceResource;
            ComponentResource resourceMap = (ComponentResource)resourceMaps.get(i);
            if (!resourceMap.getRuntimePath().equals((Object)Path.ROOT)) {
                this.reportStatus(77, resourceMap);
                if (this.INCLUDE_FLAG == 0) {
                    return false;
                }
            }
            if ((sourceResource = this.getProject().findMember(resourceMap.getSourcePath())) != null && sourceResource.exists()) {
                IPath sourcePath = this.getProject().getFullPath().append(resourceMap.getSourcePath());
                if (!this.isSourceContainer(sourcePath)) {
                    this.reportStatus(78, resourceMap);
                }
            } else {
                this.reportStatus(33, resourceMap);
            }
            if (this.INCLUDE_FLAG == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasDefaultWebResourceMappings(List resourceMaps) {
        int rootValidMaps = 0;
        IPath webInfClasses = new Path("WEB-INF/classes").makeAbsolute();
        int i = 0;
        while (i < resourceMaps.size()) {
            ComponentResource resourceMap = (ComponentResource)resourceMaps.get(i);
            IPath sourcePath = this.getProject().getFullPath().append(resourceMap.getSourcePath());
            if (resourceMap.getRuntimePath().equals((Object)Path.ROOT)) {
                ++rootValidMaps;
            } else if (resourceMap.getRuntimePath().equals((Object)webInfClasses)) {
                if (this.exists(sourcePath)) {
                    if (!this.isSourceContainer(sourcePath)) {
                        this.reportStatus(78, resourceMap);
                    }
                } else {
                    this.reportStatus(33, resourceMap);
                }
            } else {
                this.reportStatus(79, resourceMap);
            }
            if (this.INCLUDE_FLAG == 0) {
                return false;
            }
            ++i;
        }
        if (rootValidMaps != 1) {
            if (rootValidMaps < 1) {
                this.reportStatus(75);
            } else if (rootValidMaps > 1) {
                this.reportStatus(80);
            }
        }
        return this.INCLUDE_FLAG != 0;
    }

    protected boolean hasClasspathDependencies(IVirtualComponent component) {
        try {
            Map<IClasspathEntry, IClasspathAttribute> entriesToAttrib;
            boolean isWebApp = JavaEEProjectUtilities.isDynamicWebComponent(component);
            boolean webLibsOnly = false;
            if (!ClasspathDependencyEnablement.isAllowClasspathComponentDependency() && isWebApp) {
                webLibsOnly = true;
            }
            return (entriesToAttrib = ClasspathDependencyUtil.getRawComponentClasspathDependencies(JavaCoreLite.create((IProject)component.getProject()), IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY, webLibsOnly)) != null && entriesToAttrib.size() > 0;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean exists(IPath path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return workspaceRoot.exists(path);
    }

    private IProject getProject() {
        return this.component.getProject();
    }

    public boolean isSingleJavaOutputNonSource() {
        return this.isSingleJavaOutputNonSource;
    }

    public void reportStatus(int code) {
        this.reportStatus(code, null, null);
    }

    public void reportStatus(int code, ComponentResource resource) {
        this.reportStatus(code, resource, null);
    }

    public void reportStatus(int code, ComponentResource resource, String message) {
        SingleRootStatus status = new SingleRootStatus(code, resource, message);
        if (status.getSeverity() == 4) {
            if ((this.INCLUDE_FLAG & 8) != 0) {
                this.INCLUDE_FLAG = 0;
                this.addStatus(status);
            } else if ((this.INCLUDE_FLAG & 4) != 0) {
                this.addStatus(status);
            }
        } else if (status.getSeverity() == 2 && (this.INCLUDE_FLAG & 2) != 0) {
            this.addStatus(status);
        } else if (status.getSeverity() == 1 && (this.INCLUDE_FLAG & 1) != 0) {
            this.addStatus(status);
        }
    }

    public IStatus getStatus() {
        if (this.wrapperStatus != null) {
            return this.wrapperStatus;
        }
        return Status.OK_STATUS;
    }

    private void addStatus(ISingleRootStatus status) {
        if (this.wrapperStatus == null) {
            this.wrapperStatus = new MultiStatus("org.eclipse.jst.j2ee", 0, new IStatus[]{status}, null, null);
        } else {
            this.wrapperStatus.add((IStatus)status);
        }
    }
}

