/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveURIConverter;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXRendererFactory;
import org.eclipse.wst.common.internal.emf.resource.IRootObjectResource;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceFactory;

public class JavaEEEMFArchiveAdapterHelper {
    protected ResourceSet resourceSet;
    private EMFAddapter adapter = null;
    private IArchive archive = null;
    protected ArchiveURIConverter archiveURIConverter;
    private static Map<SAXFactoryKey, Resource.Factory> localFactoryMap = new HashMap<SAXFactoryKey, Resource.Factory>();

    public static IArchive findArchive(EObject eObject) {
        EList adapters = eObject.eResource().getResourceSet().eAdapters();
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof EMFAddapter)) continue;
            return ((EMFAddapter)adapter).getHelper().getArchive();
        }
        return null;
    }

    public JavaEEEMFArchiveAdapterHelper() {
    }

    public JavaEEEMFArchiveAdapterHelper(IArchive anArchive) {
        this.setArchive(anArchive);
    }

    public void setArchive(IArchive anArchive) {
        this.archive = anArchive;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    public boolean containsModelObject(IPath modelObjectPath) {
        IArchive archive = this.getArchive();
        if (archive.containsArchiveResource(modelObjectPath)) {
            URI uri = this.getArchiveURIConverter().getURI(modelObjectPath);
            return this.containsResource(uri);
        }
        return false;
    }

    protected boolean containsResource(URI uri) {
        IRootObjectResource resource = (IRootObjectResource)this.getResourceSet().getResource(uri, true);
        return resource != null && resource.getRootObject() != null;
    }

    public void setArchiveURIConverter(ArchiveURIConverter archiveURIConverter) {
        this.archiveURIConverter = archiveURIConverter;
    }

    public ArchiveURIConverter getArchiveURIConverter() {
        if (this.archiveURIConverter == null) {
            this.archiveURIConverter = new ArchiveURIConverter(this.getArchive());
        }
        return this.archiveURIConverter;
    }

    public Resource getResource(IPath resourcePath) throws ArchiveModelLoadException {
        URI uri = this.getArchiveURIConverter().getURI(resourcePath);
        Resource resource = this.getResourceSet().getResource(uri, true);
        return resource;
    }

    public Object getModelObject(IPath modelObjectPath) throws ArchiveModelLoadException {
        IRootObjectResource resource = (IRootObjectResource)this.getResource(modelObjectPath);
        return resource.getRootObject();
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.initializeResourceSet();
            if (this.adapter == null) {
                this.adapter = new EMFAddapter(this);
            }
            this.resourceSet.eAdapters().add((Object)this.adapter);
        }
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet newResourceSet) {
        if (this.resourceSet != newResourceSet) {
            if (this.resourceSet != null && this.adapter != null) {
                this.resourceSet.eAdapters().remove((Object)this.adapter);
            }
            if (newResourceSet != null && !newResourceSet.eAdapters().contains((Object)this.adapter)) {
                if (this.adapter == null) {
                    this.adapter = new EMFAddapter(this);
                }
                newResourceSet.eAdapters().add((Object)this.adapter);
            }
            this.resourceSet = newResourceSet;
        }
    }

    public void initializeResourceSet() {
        ResourceSetImpl rs = new ResourceSetImpl(){
            final String JAVA_PROTOCOL_URI_SCHEME = "java";

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private IContentDescription getContentDescription(URI uri) {
                IArchiveResource archiveResource = null;
                InputStream ioStream = null;
                try {
                    IContentDescription description;
                    IPath path = JavaEEEMFArchiveAdapterHelper.this.getArchiveURIConverter().getPath(uri);
                    archiveResource = JavaEEEMFArchiveAdapterHelper.this.getArchive().getArchiveResource(path);
                    ioStream = archiveResource.getInputStream();
                    IContentDescription iContentDescription = description = Platform.getContentTypeManager().getDescriptionFor(ioStream, path.lastSegment(), IContentDescription.ALL);
                    return iContentDescription;
                }
                catch (FileNotFoundException e) {
                    ArchiveUtil.warn((Throwable)e);
                    return null;
                }
                catch (IOException e) {
                    ArchiveUtil.warn((Throwable)e);
                    return null;
                }
                finally {
                    if (ioStream != null) {
                        try {
                            ioStream.close();
                        }
                        catch (IOException e) {
                            ArchiveUtil.warn((Throwable)e);
                        }
                    }
                }
            }

            public Resource createResource(URI uri) {
                return this.createResource(uri, "");
            }

            public Resource createResource(URI uri, String contentType) {
                IContentDescription description = null;
                if (!this.isJavaURI(uri)) {
                    description = this.getContentDescription(uri);
                }
                Resource.Factory resourceFactory = null;
                if (description != null) {
                    SAXFactoryKey key = new SAXFactoryKey(uri, description);
                    resourceFactory = JavaEEEMFArchiveAdapterHelper.getSAXResourceFactory(key);
                    if (resourceFactory == null) {
                        resourceFactory = ((WTPResourceFactoryRegistry)this.getResourceFactoryRegistry()).getFactory(uri, description);
                        Class<?> clazz = resourceFactory.getClass();
                        boolean isTranslator = false;
                        while (!isTranslator && clazz != null) {
                            if (clazz == TranslatorResourceFactory.class) {
                                isTranslator = true;
                                continue;
                            }
                            clazz = clazz.getSuperclass();
                        }
                        if (isTranslator) {
                            try {
                                Constructor<?> constructor = resourceFactory.getClass().getConstructor(RendererFactory.class);
                                EMF2SAXRendererFactory.INSTANCE.setValidating(false);
                                resourceFactory = (Resource.Factory)constructor.newInstance(EMF2SAXRendererFactory.INSTANCE);
                            }
                            catch (SecurityException e) {
                                ArchiveUtil.warn((Throwable)e);
                            }
                            catch (NoSuchMethodException e) {
                                ArchiveUtil.warn((Throwable)e);
                            }
                            catch (IllegalArgumentException e) {
                                ArchiveUtil.warn((Throwable)e);
                            }
                            catch (InstantiationException e) {
                                ArchiveUtil.warn((Throwable)e);
                            }
                            catch (IllegalAccessException e) {
                                ArchiveUtil.warn((Throwable)e);
                            }
                            catch (InvocationTargetException e) {
                                ArchiveUtil.warn((Throwable)e);
                            }
                        }
                        JavaEEEMFArchiveAdapterHelper.setSAXResourceFactory(key, resourceFactory);
                    }
                } else {
                    resourceFactory = this.getResourceFactoryRegistry().getFactory(uri);
                }
                if (resourceFactory != null) {
                    Resource result = resourceFactory.createResource(uri);
                    this.getResources().add((Object)result);
                    return result;
                }
                return null;
            }

            private boolean isJavaURI(URI uri) {
                return "java".equals(uri.scheme());
            }
        };
        rs.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        rs.setURIConverter((URIConverter)this.getArchiveURIConverter());
        this.setResourceSet((ResourceSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resource.Factory getSAXResourceFactory(SAXFactoryKey key) {
        Map<SAXFactoryKey, Resource.Factory> map = localFactoryMap;
        synchronized (map) {
            return localFactoryMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSAXResourceFactory(SAXFactoryKey key, Resource.Factory resourceFactory) {
        Map<SAXFactoryKey, Resource.Factory> map = localFactoryMap;
        synchronized (map) {
            localFactoryMap.put(key, resourceFactory);
        }
    }

    private class EMFAddapter
    extends AdapterImpl {
        private JavaEEEMFArchiveAdapterHelper helper;

        public EMFAddapter(JavaEEEMFArchiveAdapterHelper helper) {
            this.helper = helper;
        }

        public JavaEEEMFArchiveAdapterHelper getHelper() {
            return this.helper;
        }
    }

    private class SAXFactoryKey {
        private URI uri = null;
        private IContentDescription description = null;

        public SAXFactoryKey(URI uri, IContentDescription description) {
            this.uri = uri;
            this.description = description;
            if (uri == null) {
                throw new NullPointerException();
            }
            if (description == null) {
                throw new NullPointerException();
            }
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof SAXFactoryKey)) {
                return false;
            }
            SAXFactoryKey other = (SAXFactoryKey)obj;
            return this.uri.equals((Object)other.uri) && this.description.equals(other.description);
        }

        public int hashCode() {
            return this.uri.hashCode() + this.description.hashCode();
        }
    }
}

