/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.ws.internal.WSPluginMessages;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IURLProvider;

public final class ServerUtils {
    private Hashtable serverIdToLabel_;
    private Hashtable serverLabelToId_;
    private static ServerUtils instance_;

    public static ServerUtils getInstance() {
        if (instance_ == null) {
            instance_ = new ServerUtils();
        }
        return instance_;
    }

    public void getServerLabelsAndIds() {
        this.serverIdToLabel_ = new Hashtable();
        this.serverLabelToId_ = new Hashtable();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        int idx = 0;
        while (idx < serverTypes.length) {
            IServerType serverType = serverTypes[idx];
            String id = serverType.getId();
            String serverLabel = serverType.getName();
            if (id != null && serverLabel != null) {
                this.serverIdToLabel_.put(id, serverLabel);
                this.serverLabelToId_.put(serverLabel, id);
            }
            ++idx;
        }
    }

    public String getServerLabelForId(String factoryId) {
        if (this.serverIdToLabel_ == null) {
            this.getServerLabelsAndIds();
        }
        return (String)this.serverIdToLabel_.get(factoryId);
    }

    public String getServerIdForLabel(String factoryLabel) {
        if (this.serverLabelToId_ == null) {
            this.getServerLabelsAndIds();
        }
        return (String)this.serverLabelToId_.get(factoryLabel);
    }

    public IStatus modifyModules(IEnvironment env, IServer server, IModule module, boolean add, IProgressMonitor monitor) {
        IServerWorkingCopy wc = null;
        IStatus status = Status.OK_STATUS;
        try {
            IProject project;
            IModule pm;
            if (module == null || !module.getProject().exists()) {
                IStatus iStatus = status;
                return iStatus;
            }
            if (module instanceof IModule && (pm = module) != null && ((project = pm.getProject()) == null || ResourceUtils.isTrueJavaProject(project))) {
                IStatus iStatus = status;
                return iStatus;
            }
            try {
                wc = server.createWorkingCopy();
                if (wc != null) {
                    List<IModule> list = Arrays.asList(server.getModules());
                    if (add) {
                        if (!list.contains(module)) {
                            ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                        }
                    } else if (list.contains(module)) {
                        ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[0], (IModule[])new IModule[]{module}, (IProgressMonitor)monitor);
                    }
                }
            }
            catch (CoreException exc) {
                status = StatusUtils.errorStatus((String)WSPluginMessages.MSG_ERROR_SERVER, (Throwable)exc);
                env.getStatusHandler().reportError(status);
                IStatus iStatus = status;
                return iStatus;
            }
        }
        finally {
            if (wc != null) {
                try {
                    wc.saveAll(true, monitor);
                }
                catch (CoreException exc) {
                    status = StatusUtils.errorStatus((String)WSPluginMessages.MSG_ERROR_SERVER, (Throwable)exc);
                    env.getStatusHandler().reportError(status);
                    return status;
                }
            }
        }
        return status;
    }

    public static IServer getServerForModule(IModule module, String serverTypeId, IServer server, boolean create, IProgressMonitor monitor) {
        if (server != null) {
            return server;
        }
        return ServerUtils.getServerForModule(module, serverTypeId, create, monitor);
    }

    public static IServer getServerForModule(IModule module, String serverTypeId, boolean create, IProgressMonitor monitor) {
        try {
            IServer[] servers = ServerUtil.getServersByModule((IModule)module, (IProgressMonitor)monitor);
            if (servers != null && servers.length > 0) {
                if (serverTypeId == null || serverTypeId.length() == 0) {
                    return servers[0];
                }
                int i = 0;
                while (i < servers.length) {
                    if (servers[i].getServerType().getId().equalsIgnoreCase(serverTypeId)) {
                        return servers[i];
                    }
                    ++i;
                }
            }
            return ServerUtils.createServer(module, serverTypeId, monitor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IServer getServerForModule(IModule module) {
        try {
            IServer[] servers = ServerUtil.getServersByModule((IModule)module, null);
            return servers != null && servers.length > 0 ? servers[0] : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IServer createServer(IEnvironment env, IModule module, String serverTypeId, IProgressMonitor monitor) {
        IServerWorkingCopy serverWC = null;
        IServer server = null;
        try {
            IServerType serverType = ServerCore.findServerType((String)serverTypeId);
            serverWC = serverType.createServer(serverTypeId, null, monitor);
            try {
                if (serverWC != null) {
                    server = serverWC.saveAll(true, monitor);
                }
            }
            catch (CoreException ce) {
                IStatus status = StatusUtils.errorStatus((String)WSPluginMessages.MSG_ERROR_SERVER, (Throwable)ce);
                env.getStatusHandler().reportError(status);
                return null;
            }
            if (server != null && module != null && module.getProject().exists()) {
                IModule[] parentModules = server.getRootModules(module, monitor);
                if (parentModules != null && parentModules.length != 0) {
                    module = parentModules[0];
                }
                serverWC.modifyModules(new IModule[]{module}, new IModule[0], monitor);
            }
            IServer iServer = server;
            return iServer;
        }
        catch (Exception e) {
            IStatus status = StatusUtils.errorStatus((String)WSPluginMessages.MSG_ERROR_SERVER, (Throwable)e);
            env.getStatusHandler().reportError(status);
            return null;
        }
        finally {
            try {
                if (serverWC != null) {
                    serverWC.saveAll(true, monitor);
                }
            }
            catch (CoreException ce) {
                IStatus status = StatusUtils.errorStatus((String)WSPluginMessages.MSG_ERROR_SERVER, (Throwable)ce);
                env.getStatusHandler().reportError(status);
                return null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static IServer createServer(IModule module, String serverTypeId, IProgressMonitor monitor) {
        serverWC = null;
        server = null;
        serverType = ServerCore.findServerType((String)serverTypeId);
        serverWC = serverType.createServer(serverTypeId, null, monitor);
        try {
            if (serverWC != null) {
                server = serverWC.saveAll(true, monitor);
            }
        }
        catch (CoreException v0) lbl-1000:
        // 2 sources

        {
            while (true) {
                try {
                    if (serverWC != null) {
                        serverWC.saveAll(true, monitor);
                    }
                }
                catch (CoreException v1) {
                    return null;
                }
                return null;
            }
        }
        if (server != null && module != null) {
            parentModules = server.getRootModules(module, monitor);
            if (parentModules != null && parentModules.length != 0) {
                module = parentModules[0];
            }
            serverWC.modifyModules(new IModule[]{module}, new IModule[0], monitor);
        }
        var8_7 = server;
        try {
            if (serverWC != null) {
                serverWC.saveAll(true, monitor);
            }
        }
        catch (CoreException v2) {
            return null;
        }
        return var8_7;
        catch (Exception v3) {
            try {
                ** continue;
            }
            catch (Throwable var7_8) {
                try {
                    if (serverWC != null) {
                        serverWC.saveAll(true, monitor);
                    }
                }
                catch (CoreException v4) {
                    return null;
                }
                throw var7_8;
            }
        }
    }

    public static String[] getServerTypeIdsByModule(IVirtualComponent component) {
        IServer[] servers;
        IProject project = component.getProject();
        String[] serverIds = null;
        if (project != null && (servers = ServerUtil.getServersByModule((IModule)ServerUtils.getModule(project), null)) != null) {
            serverIds = new String[servers.length];
            int index = 0;
            while (index < servers.length) {
                serverIds[index] = servers[index].getId();
                ++index;
            }
        }
        if (serverIds == null) {
            serverIds = new String[]{};
        }
        return serverIds;
    }

    public static String[] getServerTypeIdsByModule(IProject project) {
        IServer[] servers;
        Vector<String> serverIds = new Vector<String>();
        if (project != null && (servers = ServerUtil.getServersByModule((IModule)ResourceUtils.getModule(project), null)) != null && servers.length > 0) {
            int i = 0;
            while (i < servers.length) {
                serverIds.add(servers[i].getId());
                ++i;
            }
        }
        return serverIds.toArray(new String[serverIds.size()]);
    }

    public static IModule getModule(IProject project) {
        return ServerUtil.getModule((IProject)project);
    }

    public static IModule getModule(IProject project, String module) {
        if (module == null) {
            return ServerUtils.getModule(project);
        }
        IModule[] modules = ServerUtil.getModules((IProject)project);
        int length = modules.length;
        int i = 0;
        while (i < length) {
            IModule aModule = modules[i];
            if (module.equals(aModule.getName())) {
                return aModule;
            }
            ++i;
        }
        return null;
    }

    public static String getWebComponentURL(IProject project, String serverFactoryId) {
        IServerType serverType;
        String webProjectURL = null;
        IModule module = ServerUtils.getModule(project);
        if (module != null && (serverType = ServerCore.findServerType((String)serverFactoryId)) != null) {
            try {
                URL url;
                IServerWorkingCopy serverWC;
                IURLProvider urlProvider;
                IRuntime nonStubRuntime = null;
                IRuntime[] runtimes = ServerUtil.getRuntimes(null, null);
                String serverRuntimeTypeId = serverType.getRuntimeType().getId();
                int i = 0;
                while (i < runtimes.length) {
                    String thisRuntimeTypeId;
                    IRuntime runtime = runtimes[i];
                    IRuntimeType runtimeType = runtime.getRuntimeType();
                    if (runtimeType != null && (thisRuntimeTypeId = runtimeType.getId()).equals(serverRuntimeTypeId) && !runtime.isStub()) {
                        nonStubRuntime = runtime;
                        break;
                    }
                    ++i;
                }
                if (nonStubRuntime != null && (urlProvider = (IURLProvider)(serverWC = serverType.createServer(null, null, nonStubRuntime, null)).loadAdapter(IURLProvider.class, null)) != null && (url = urlProvider.getModuleRootURL(module)) != null) {
                    String s = url.toString();
                    webProjectURL = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
                }
            }
            catch (CoreException ce) {
                Logger.getLogger().log((Throwable)ce);
            }
        }
        return webProjectURL;
    }

    public static String getWebComponentURL(IProject project, String serverFactoryId, IServer server) {
        String webProjectURL = null;
        IModule module = ServerUtils.getModule(project);
        if (module != null) {
            if (server != null) {
                URL url;
                IURLProvider urlProvider = (IURLProvider)server.loadAdapter(IURLProvider.class, null);
                if (urlProvider != null && (url = urlProvider.getModuleRootURL(module)) != null) {
                    String s = url.toString();
                    webProjectURL = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
                }
            } else {
                webProjectURL = ServerUtils.getWebComponentURL(project, serverFactoryId);
            }
        }
        return webProjectURL;
    }

    public static String getEncodedWebComponentURL(IProject project, String serverFactoryId) {
        String url = ServerUtils.getWebComponentURL(project, serverFactoryId);
        return ServerUtils.encodeURL(url);
    }

    public static String getEncodedWebComponentURL(IProject project, String serverFactoryId, IServer server) {
        String url = ServerUtils.getWebComponentURL(project, serverFactoryId, server);
        return ServerUtils.encodeURL(url);
    }

    public static String encodeURL(String url) {
        int index;
        if (url != null && (index = url.lastIndexOf(47)) != -1) {
            StringBuffer encodedURL = new StringBuffer();
            encodedURL.append(url.substring(0, index + 1));
            try {
                String ctxtRoot = URLEncoder.encode(url.substring(index + 1, url.length()), "UTF-8");
                int plusIndex = ctxtRoot.indexOf(43);
                while (plusIndex != -1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(ctxtRoot.substring(0, plusIndex));
                    sb.append("%20");
                    sb.append(ctxtRoot.substring(plusIndex + 1, ctxtRoot.length()));
                    ctxtRoot = sb.toString();
                    plusIndex = ctxtRoot.indexOf(43);
                }
                encodedURL.append(ctxtRoot);
            }
            catch (IOException iOException) {}
            url = encodedURL.toString();
        }
        return url;
    }

    public static IServer getDefaultExistingServer(IVirtualComponent component) {
        IProject project = component.getProject();
        IModule module = ServerUtils.getModule(project);
        IServer preferredServer = ServerCore.getDefaultServer((IModule)module);
        if (preferredServer != null) {
            return preferredServer;
        }
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)module, null);
        if (configuredServers != null && configuredServers.length > 0) {
            preferredServer = configuredServers[0];
        } else {
            IServer[] nonConfiguredServers = ServerUtil.getAvailableServersForModule((IModule)module, (boolean)false, null);
            if (nonConfiguredServers != null && nonConfiguredServers.length > 0) {
                preferredServer = nonConfiguredServers[0];
            }
        }
        return preferredServer;
    }

    public static IServer getDefaultExistingServer(IProject project) {
        IModule module = ServerUtil.getModule((IProject)project);
        IServer preferredServer = null;
        preferredServer = ServerCore.getDefaultServer((IModule)module);
        if (preferredServer != null) {
            return preferredServer;
        }
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)ResourceUtils.getModule(project), null);
        if (configuredServers != null && configuredServers.length > 0) {
            return configuredServers[0];
        }
        IServer[] nonConfiguredServers = ServerUtil.getAvailableServersForModule((IModule)ResourceUtils.getModule(project), (boolean)false, null);
        if (nonConfiguredServers != null && nonConfiguredServers.length > 0) {
            return nonConfiguredServers[0];
        }
        return null;
    }

    public static String getServerTargetIdFromFactoryId(String serverFactoryId, String moduleType, String j2eeVersion) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType == null) {
            return null;
        }
        String serverRuntimeTypeId = serverType.getRuntimeType().getId();
        String stJ2EEVersion = ServerUtils.getServerTargetJ2EEVersion(j2eeVersion);
        List<IRuntime> runtimes = Arrays.asList(ServerUtil.getRuntimes((String)moduleType, (String)stJ2EEVersion));
        int i = 0;
        while (i < runtimes.size()) {
            String thisRuntimeTypeId;
            IRuntime runtime = runtimes.get(i);
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != null && (thisRuntimeTypeId = runtimeType.getId()).equals(serverRuntimeTypeId) && !runtime.isStub()) {
                return runtime.getId();
            }
            ++i;
        }
        return null;
    }

    public static String getRuntimeTargetIdFromFactoryId(String serverFactoryId) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType != null) {
            String serverRuntimeId = serverType.getRuntimeType().getId();
            return serverRuntimeId;
        }
        return "";
    }

    public static String getFactoryIdFromRuntimeTargetId(String runtimeTargetId) {
        IServerType[] serverTypes = ServerCore.getServerTypes();
        int i = 0;
        while (i < serverTypes.length) {
            IRuntimeType runtimeTyp = serverTypes[i].getRuntimeType();
            if (runtimeTyp != null && runtimeTyp.getId().equals(runtimeTargetId)) {
                return serverTypes[i].getId();
            }
            ++i;
        }
        return "";
    }

    public static String getServerTypeIdFromFactoryId(String serverFactoryId) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType != null) {
            String serverTypeId = serverType.getId();
            return serverTypeId;
        }
        return "";
    }

    public static boolean isTargetValidForEAR(String runtimeTargetId, String j2eeVersion) {
        if (runtimeTargetId == null) {
            return false;
        }
        String earModuleType = "jst.ear";
        String stJ2EEVersion = ServerUtils.getServerTargetJ2EEVersion(j2eeVersion);
        List<IRuntime> runtimes = Arrays.asList(ServerUtil.getRuntimes((String)earModuleType, (String)stJ2EEVersion));
        int i = 0;
        while (i < runtimes.size()) {
            String thisId;
            IRuntime runtime = runtimes.get(i);
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != null && (thisId = runtimeType.getId()).equals(runtimeTargetId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTargetValidForProjectType(String runtimeTargetId, String j2eeVersion, String projectType) {
        if (runtimeTargetId == null) {
            return false;
        }
        if (projectType == null || projectType.length() == 0) {
            return false;
        }
        String stJ2EEVersion = ServerUtils.getServerTargetJ2EEVersion(j2eeVersion);
        List<IRuntime> runtimes = Arrays.asList(ServerUtil.getRuntimes((String)projectType, (String)stJ2EEVersion));
        int i = 0;
        while (i < runtimes.size()) {
            String thisId;
            IRuntime runtime = runtimes.get(i);
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != null && (thisId = runtimeType.getId()).equals(runtimeTargetId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getServerTargetJ2EEVersion(String j2eeVersion) {
        if (j2eeVersion == null || j2eeVersion.length() == 0) {
            return null;
        }
        int j2eeVersionInt = Integer.parseInt(j2eeVersion);
        switch (j2eeVersionInt) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return null;
    }

    public static String getServerTargetModuleType(int moduleType) {
        switch (moduleType) {
            case 1: {
                return "j2ee.web";
            }
            case 2: {
                return "j2ee.ejb";
            }
            case 4: {
                return "j2ee.appclient";
            }
            case 8: {
                return "j2ee.ear";
            }
        }
        return null;
    }

    public static IRuntime getNonStubRuntime(String serverFactoryId) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        IRuntime nonStubRuntime = null;
        if (serverType != null) {
            IRuntime[] runtimes = ServerUtil.getRuntimes(null, null);
            String serverRuntimeTypeId = serverType.getRuntimeType().getId();
            int i = 0;
            while (i < runtimes.length) {
                String thisRuntimeTypeId;
                IRuntime runtime = runtimes[i];
                IRuntimeType runtimeType = runtime.getRuntimeType();
                if (runtimeType != null && (thisRuntimeTypeId = runtimeType.getId()).equals(serverRuntimeTypeId) && !runtime.isStub()) {
                    nonStubRuntime = runtime;
                    break;
                }
                ++i;
            }
        }
        return nonStubRuntime;
    }
}

