/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.contentmodel.annotation.internal;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jst.jsf.contentmodel.annotations.Activator;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMAnnotation;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMAttributeAnnotation;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.CMElementAnnotation;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.CMAnnotationPropertyValue;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.CMAnnotationSourceFileLocator;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.ICMAnnotationSourceFileInfo;

public class CMAnnotationMap {
    protected Map cmNodeToAnnotationMap = new Hashtable();
    protected boolean isCaseSensitive = true;
    protected ICMAnnotationSourceFileInfo fileInfo;
    private ResourceBundle resourceBundle;
    private CMAnnotationSourceFileLocator locator;

    public CMAnnotationMap(ICMAnnotationSourceFileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setLocator(CMAnnotationSourceFileLocator locator) {
        this.locator = locator;
    }

    public CMElementAnnotation getElementAnnotation(String elementName) {
        CMElementAnnotation elem = null;
        if (this.cmNodeToAnnotationMap.containsKey(elementName)) {
            List annos = (List)this.cmNodeToAnnotationMap.get(elementName);
            Iterator it = annos.iterator();
            while (it.hasNext()) {
                elem = (CMElementAnnotation)it.next();
                if (elem.getName() == elementName) break;
            }
        }
        return elem;
    }

    public void addCMElementAnnotation(CMElementAnnotation annotation) {
        this.addAnnotationForCMNodeName(annotation.getName(), annotation);
    }

    private void addAnnotationForCMNodeName(String cmNodeName, CMElementAnnotation annotation) {
        Vector<CMElementAnnotation> list = (Vector<CMElementAnnotation>)this.cmNodeToAnnotationMap.get(cmNodeName);
        if (list == null) {
            list = new Vector<CMElementAnnotation>();
            this.cmNodeToAnnotationMap.put(cmNodeName, list);
        }
        list.add(annotation);
    }

    public List getCMElementPropertyValues(String elementName, String propertyName) {
        List result = null;
        String key = this.getStringValueForCaseSensitivity(elementName);
        String propName = this.getStringValueForCaseSensitivity(propertyName);
        List annotationList = (List)this.cmNodeToAnnotationMap.get(key);
        if (annotationList != null) {
            Iterator i = annotationList.iterator();
            while (i.hasNext()) {
                CMAnnotation annotation = (CMAnnotation)i.next();
                if (annotation.getAnnotationProperty(propName) == null) continue;
                result = this.getNLSPropertyValues(annotation, propName);
                break;
            }
        }
        return result;
    }

    public String getCMElementProperty(String elementName, String propertyName) {
        String result = null;
        List vals = this.getCMElementPropertyValues(elementName, propertyName);
        if (vals != null && vals.get(0) != null) {
            result = vals.get(0).toString();
        }
        return result;
    }

    public List getCMAttributePropertyValues(String elementName, String attributeName, String propertyName) {
        List propVals;
        CMAttributeAnnotation annotationForAttr;
        List result = null;
        String key = this.getStringValueForCaseSensitivity(elementName);
        String attrName = this.getStringValueForCaseSensitivity(attributeName);
        String propName = this.getStringValueForCaseSensitivity(propertyName);
        List annotationListForElement = (List)this.cmNodeToAnnotationMap.get(key);
        if (annotationListForElement != null && (annotationForAttr = this.getCMAttributeAnnotation(annotationListForElement, attrName)) != null && annotationForAttr.getAnnotationProperty(propName) != null && (propVals = this.getNLSPropertyValues(annotationForAttr, propName)) != null) {
            result = propVals;
        }
        return result;
    }

    public String getCMAttributeProperty(String elementName, String attributeName, String propertyName) {
        String result = null;
        List propVals = this.getCMAttributePropertyValues(elementName, attributeName, propertyName);
        if (propVals != null) {
            result = (String)propVals.get(0);
        }
        return result;
    }

    public CMAnnotationPropertyValue getCMAttributePropertyValue(String elementName, String attributeName, String propertyName) {
        CMAnnotationPropertyValue result = null;
        List val = this.getCMAttributePropertyValues(elementName, attributeName, propertyName);
        if (val != null) {
            result = new CMAnnotationPropertyValue(this.fileInfo, val);
        }
        return result;
    }

    public CMAnnotationPropertyValue getCMElementPropertyValue(String elementName, String propertyName) {
        CMAnnotationPropertyValue result = null;
        List val = this.getCMElementPropertyValues(elementName, propertyName);
        if (val != null) {
            result = new CMAnnotationPropertyValue(this.fileInfo, val);
        }
        return result;
    }

    private CMAttributeAnnotation getCMAttributeAnnotation(List annotationListForElement, String attributeName) {
        int i = 0;
        while (i < annotationListForElement.size()) {
            CMAttributeAnnotation attributeAnnotation;
            Map attributeAnnotations;
            CMElementAnnotation annotationForElement = (CMElementAnnotation)annotationListForElement.get(i);
            if (annotationForElement != null && (attributeAnnotations = annotationForElement.getAttributeAnnotations()) != null && (attributeAnnotation = (CMAttributeAnnotation)attributeAnnotations.get(attributeName)) != null) {
                return attributeAnnotation;
            }
            ++i;
        }
        return null;
    }

    private List getNLSPropertyValues(CMAnnotation annotation, String propertyName) {
        List result = annotation.getAnnotationProperty(propertyName).getPropertyValues();
        int i = 0;
        while (i < result.size()) {
            String val = (String)result.get(i);
            if (val.startsWith("%") && !val.startsWith("%%")) {
                val = this.getNLSPropertyValue(val);
                result.set(i, val);
                annotation.getAnnotationProperty(propertyName).getPropertyValues().set(i, val);
            }
            ++i;
        }
        return result;
    }

    private String getNLSPropertyValue(String val) {
        String NOT_FOUND = "(key not found)";
        try {
            ResourceBundle resourceBundle = this.getResourceBundle();
            if (resourceBundle != null) {
                String replVal = resourceBundle.getString(val.substring(1));
                return replVal;
            }
            return val;
        }
        catch (IOException e) {
            Activator.log(e, "IOException for NLSPropertyValue: " + val);
            return null;
        }
        catch (MissingResourceException e) {
            Activator.log(e, "MissingResourceException for NLSPropertyValue: " + val);
            return String.valueOf(val.substring(1)) + NOT_FOUND;
        }
    }

    public ICMAnnotationSourceFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public String getStringValueForCaseSensitivity(String val) {
        return this.isCaseSensitive ? val : val.toLowerCase();
    }

    private ResourceBundle getResourceBundle() throws IOException {
        if (this.resourceBundle == null) {
            this.resourceBundle = this.locator.getResourceBundle();
        }
        return this.resourceBundle;
    }
}

