/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el;

import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;

class ValueExpressionTracker {
    private final IProject _project;
    private ISymbol _rootSymbol;
    private boolean _isRootValid;
    private IPropertySymbol _curPropertySymbol;
    private int _curPropertySymbolOffset;
    private int _curPropertySymbolLength;
    private boolean _errorFlag;

    public ValueExpressionTracker(IProject project) {
        this._project = project;
    }

    public void setRootSymbol(ISymbol rootSymbol) {
        this._isRootValid = rootSymbol != null;
        this._rootSymbol = rootSymbol;
    }

    public boolean isRootValid() {
        return this._isRootValid;
    }

    public ISymbol getRootSymbol() {
        return this._rootSymbol;
    }

    public boolean isValidMemberOfRoot(String name) {
        if (this._rootSymbol == null || name == null || "".equals(name)) {
            return false;
        }
        return this.isValidMember(this._rootSymbol, name);
    }

    protected boolean isValidMember(ISymbol symbol, String name) {
        return this.getPropertySymbol(symbol, name) != null;
    }

    protected ISymbol getPropertySymbol(ISymbol symbol, String name) {
        DesignTimeApplicationManager dtAppMgr = DesignTimeApplicationManager.getInstance((IProject)this._project);
        return dtAppMgr.getPropertyResolver().getProperty(symbol, (Object)name);
    }

    public IPropertySymbol getNextPropertySymbol(String name) {
        IPropertySymbol curSymbol = this._curPropertySymbol != null ? this._curPropertySymbol : this._rootSymbol;
        return (IPropertySymbol)this.getPropertySymbol((ISymbol)curSymbol, name);
    }

    public boolean isValidMemberOfCurrentSymbol(String name) {
        if (this._curPropertySymbol == null) {
            return this.isValidMemberOfRoot(name);
        }
        return this.isValidMember((ISymbol)this._curPropertySymbol, name);
    }

    public IPropertySymbol getCurPropertySymbol() {
        return this._curPropertySymbol;
    }

    public void setCurPropertySymbol(IPropertySymbol propertySymbol, int offset, int length) {
        this._curPropertySymbol = propertySymbol;
        this._curPropertySymbolOffset = offset;
        this._curPropertySymbolLength = length;
    }

    public int getCurPropertySymbolOffset() {
        return this._curPropertySymbolOffset;
    }

    public int getCurPropertySymbolLength() {
        return this._curPropertySymbolLength;
    }

    public boolean isErrorFlag() {
        return this._errorFlag;
    }

    public void setErrorFlag(boolean flag) {
        if (!this._errorFlag) {
            this._errorFlag = flag;
        }
    }

    public String resolveType() {
        if (!this._isRootValid || this._rootSymbol == null) {
            throw new IllegalStateException("Cannot resolve type without root symbol");
        }
        if (this._errorFlag) {
            return null;
        }
        if (this._curPropertySymbol == null) {
            ITypeDescriptor typeDesc = ((IInstanceSymbol)this._rootSymbol).getTypeDescriptor();
            String typeDescString = typeDesc.getTypeSignature();
            if (typeDescString != null) {
                return typeDescString;
            }
            return null;
        }
        ITypeDescriptor typeDesc = this._curPropertySymbol.getTypeDescriptor();
        String typeSignature = typeDesc.getTypeSignature();
        if (typeSignature != null) {
            return typeSignature;
        }
        return null;
    }
}

