/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors.internal.provisional;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.metadataprocessors.internal.IMetaDataEnabledFeatureExtension;
import org.eclipse.jst.jsf.metadataprocessors.internal.MetaDataEnabledFeatureAdapterFactory;
import org.eclipse.jst.jsf.metadataprocessors.internal.MetaDataEnabledFeatureRegistry;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.AbstractMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.IType;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.ITypeDescriptor;

public abstract class AbstractRootTypeDescriptor
extends AbstractMetaDataEnabledFeature
implements ITypeDescriptor {
    private IType type;

    public List getFeatureAdapters(Class processingFeature) {
        Assert.isTrue((boolean)processingFeature.isInterface());
        ArrayList<AbstractRootTypeDescriptor> ret = new ArrayList<AbstractRootTypeDescriptor>(3);
        if (processingFeature.isInstance(this)) {
            this.setBundleID(this.type.getBundleID());
            ret.add(this);
        }
        ret.addAll(this.findMetaDataEnabledFeaturesForThisType(processingFeature));
        return ret;
    }

    protected final List findMetaDataEnabledFeaturesForThisType(Class processingFeature) {
        ArrayList<IMetaDataEnabledFeature> ret = new ArrayList<IMetaDataEnabledFeature>(3);
        List extensions = MetaDataEnabledFeatureRegistry.getInstance().getFeatures(this.getTypeExtension().getTypeID());
        if (!extensions.isEmpty()) {
            int i = 0;
            while (i < extensions.size()) {
                IMetaDataEnabledFeatureExtension aFeature = (IMetaDataEnabledFeatureExtension)extensions.get(i);
                IMetaDataEnabledFeature feature = MetaDataEnabledFeatureAdapterFactory.getInstance().getFeatureAdapter(aFeature, processingFeature);
                if (feature != null && processingFeature.isInstance(feature)) {
                    ret.add(feature);
                }
                ++i;
            }
        }
        return ret;
    }

    public IType getTypeExtension() {
        return this.type;
    }

    public void setTypeExtension(IType type) {
        this.type = type;
    }
}

