/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.dialogfield;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.facesconfig.common.CommonPlugin;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogs.CommonResourceDialog;
import org.eclipse.jst.jsf.facesconfig.common.utils.PathUtil;
import org.eclipse.swt.widgets.Shell;

public class ResourceButtonDialogField
extends StringButtonDialogField {
    private IProject project;
    private String[] suffixs;
    private String resourceDescription;
    private IFile referredFile;
    private boolean isWebPath = false;
    private IFolder folder;
    private String separator = "";

    public ResourceButtonDialogField(IProject project) {
        this(null, project);
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                String oldValue = ResourceButtonDialogField.this.getText();
                String newValue = ResourceButtonDialogField.this.browseButtonPressed();
                if (newValue != null && !newValue.equals(oldValue)) {
                    ResourceButtonDialogField.this.setText(newValue);
                }
            }
        });
    }

    public ResourceButtonDialogField(IStringButtonAdapter adapter, IProject project) {
        super(adapter);
        this.project = project;
    }

    protected String browseButtonPressed() {
        Shell shell = this.getShell();
        CommonResourceDialog dialog = null;
        int style = "".equals(this.separator) ? 0 : 770;
        dialog = this.folder != null ? new CommonResourceDialog(shell, this.folder, style) : new CommonResourceDialog(shell, this.project, style);
        dialog.setTitle(CommonPlugin.getResourceString("DialogField.ResourceButton.SelectFile"));
        dialog.setSuffixs(this.suffixs);
        dialog.setResourceDescription(this.resourceDescription);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < result.length) {
                String newValue = null;
                IPath path = ((IFile)result[i]).getLocation();
                IPath referredPath = null;
                referredPath = this.referredFile != null ? this.referredFile.getLocation() : this.project.getLocation();
                if (this.isWebPath) {
                    IFile selectedFile = (IFile)result[i];
                    newValue = PathUtil.convertToWebPath(selectedFile.getFullPath());
                } else {
                    newValue = PathUtil.convertToRelativePath(path.toString(), referredPath.toString());
                }
                buffer.append(newValue);
                buffer.append(this.separator);
                ++i;
            }
            if (buffer.length() > 0) {
                return buffer.substring(0, buffer.length() - this.separator.length());
            }
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public void setFolder(IFolder folder) {
        this.folder = folder;
    }

    public IFile getReferredFile() {
        return this.referredFile;
    }

    public void setReferredFile(IFile referredFile) {
        this.referredFile = referredFile;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public String[] getSuffixs() {
        return this.suffixs;
    }

    public void setSuffixs(String[] suffixs) {
        this.suffixs = suffixs;
    }

    public void setWebPath(boolean isWebPath) {
        this.isWebPath = isWebPath;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

