/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.dialogfield;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.facesconfig.common.CommonPlugin;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogs.ResourceOnClasspathDialog;
import org.eclipse.swt.widgets.Shell;

public class ClasspathResourceButtonDialogField
extends StringButtonDialogField {
    private IProject project;
    private static final String[] PROPERTIES_FILES_SUFFIXS = new String[]{"properties"};

    public ClasspathResourceButtonDialogField(IProject project) {
        this(null, project);
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                ClasspathResourceButtonDialogField.this.browseButtonPressed();
            }
        });
    }

    public ClasspathResourceButtonDialogField(IStringButtonAdapter adapter, IProject project) {
        super(adapter);
        this.project = project;
    }

    private void browseButtonPressed() {
        String newValue;
        String oldValue;
        Shell shell = this.getShell();
        ResourceOnClasspathDialog dialog = new ResourceOnClasspathDialog(shell, this.getJavaProject());
        dialog.setTitle(CommonPlugin.getResourceString("DialogField.ResourceButton.SelectFile"));
        dialog.setSuffixs(PROPERTIES_FILES_SUFFIXS);
        if (dialog.open() == 0 && (oldValue = this.getText()) != (newValue = (String)dialog.getResult()[0])) {
            this.setText(newValue);
        }
    }

    private IJavaProject getJavaProject() {
        try {
            if (this.project != null && this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)this.project);
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

