/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.internal.provisional.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.ObjectType;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.CMAnnotationHelper;

public class JavaClassType
extends ObjectType
implements IPossibleValues,
IValidValues {
    public static final String POSSIBLE_VALUES_INTERFACES_PROP_NAME = "valid-interfaces";
    public static final String POSSIBLE_VALUES_SUPERCLASS_PROP_NAME = "valid-superclass";
    private List validationMsgs;

    public List getPossibleValues() {
        List results = this.getTypes();
        if (!results.isEmpty()) {
            ArrayList<PossibleValue> vals = new ArrayList<PossibleValue>(results.size());
            Iterator it = results.iterator();
            while (it.hasNext()) {
                SearchMatch match = (SearchMatch)it.next();
                IJavaElement res = (IJavaElement)match.getElement();
                vals.add(this.createPossibleValue(res));
            }
            return vals;
        }
        return new ArrayList(0);
    }

    private List getTypes() {
        if (this.getStructuredDocumentContext() == null) {
            return null;
        }
        IWorkspaceContextResolver docResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.getStructuredDocumentContext());
        if (docResolver != null) {
            IProject proj = docResolver.getProject();
            IJavaProject jp = JavaCore.create((IProject)proj);
            if (jp == null) {
                return null;
            }
            ArrayList<IJavaElement> elems = new ArrayList<IJavaElement>();
            elems.addAll(this.getInterfaces(jp));
            IJavaElement sc = this.getSuperClass(jp);
            if (sc != null) {
                elems.add(sc);
            }
            if (elems.size() > 0) {
                IJavaElement[] elements = elems.toArray(new IJavaElement[0]);
                JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
                IJavaSearchScope scope = factory.createJavaSearchScope(new IJavaElement[]{jp}, false);
                factory.getSelectionScopeDescription(elements, false);
                SearchPattern combined = SearchPattern.createPattern((IJavaElement)((IJavaElement)elems.get(0)), (int)1, (int)0);
                Searcher requestor = new Searcher();
                SearchEngine engine = new SearchEngine();
                try {
                    engine.search(combined, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
                }
                catch (CoreException coreException) {}
                return requestor.getResults();
            }
        }
        return new ArrayList(0);
    }

    private List getInterfaces(IJavaProject jp) {
        ArrayList<IType> ret = new ArrayList<IType>();
        List propVals = this.getInterfaceNames();
        new ArrayList();
        Iterator it = propVals.iterator();
        while (it.hasNext()) {
            String propVal = (String)it.next();
            IType interfase = null;
            try {
                interfase = JavaModelUtil.findType((IJavaProject)jp, (String)propVal);
                if (interfase == null) continue;
                ret.add(interfase);
            }
            catch (JavaModelException javaModelException) {}
        }
        return ret;
    }

    private IJavaElement getSuperClass(IJavaProject jp) {
        IType superclass = null;
        try {
            String sc = this.getSuperClassName();
            if (sc != null && !sc.trim().equals("") && (superclass = JavaModelUtil.findType((IJavaProject)jp, (String)sc)) != null) {
                return superclass;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private PossibleValue createPossibleValue(IJavaElement val) {
        return new PossibleValue(((IType)val).getFullyQualifiedName());
    }

    public List getValidationMessages() {
        if (this.validationMsgs == null) {
            this.validationMsgs = new ArrayList();
        }
        return this.validationMsgs;
    }

    public boolean isValidValue(String value) {
        if (value == null || value.trim().equals("")) {
            this.getValidationMessages().add(new ValidationMessage(Messages.JavaClassType_invalid_type));
            return false;
        }
        List results = this.getTypes();
        if (!results.isEmpty()) {
            new ArrayList(results.size());
            Iterator it = results.iterator();
            while (it.hasNext()) {
                SearchMatch match = (SearchMatch)it.next();
                IType res = (IType)match.getElement();
                if (!res.getFullyQualifiedName().equals(value)) continue;
                return true;
            }
        }
        this.addNewValidationMessage(Messages.JavaClassType_not_found);
        return false;
    }

    protected String getSuperClassName() {
        return CMAnnotationHelper.getCMAttributePropertyValue((String)this.getCMAnnotationContext().getBundleId(), (String)this.getCMAnnotationContext().getUri(), (String)this.getCMAnnotationContext().getElementName(), (String)this.getCMAnnotationContext().getAttributeName(), (String)POSSIBLE_VALUES_SUPERCLASS_PROP_NAME);
    }

    protected List getInterfaceNames() {
        return CMAnnotationHelper.getCMAttributePropertyValues((String)this.getCMAnnotationContext().getBundleId(), (String)this.getCMAnnotationContext().getUri(), (String)this.getCMAnnotationContext().getElementName(), (String)this.getCMAnnotationContext().getAttributeName(), (String)POSSIBLE_VALUES_INTERFACES_PROP_NAME);
    }

    protected void addNewValidationMessage(String defaultMsg) {
        String msg = this.getCMValidationMessage();
        if (msg == null || msg.equals("")) {
            msg = defaultMsg;
        }
        String code = this.getCMValidationCode();
        int severity = this.getCMValidationSeverity();
        ValidationMessage val = new ValidationMessage(msg, code, severity);
        this.getValidationMessages().add(val);
    }

    protected String getCMValidationMessage() {
        return this.getCMPropertyValue("valid-values-message");
    }

    protected int getCMValidationSeverity() {
        String val = this.getCMPropertyValue("valid-values-severity");
        if (val == null) {
            return 2;
        }
        int severity = Integer.valueOf(val);
        return severity;
    }

    protected String getCMValidationCode() {
        return this.getCMPropertyValue("valid-values-code");
    }

    private class Searcher
    extends SearchRequestor {
        private List results = new ArrayList();

        private Searcher() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.results.add(match);
        }

        public List getResults() {
            return this.results;
        }
    }
}

