/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues;

import java.util.List;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.NumberType;
import org.eclipse.osgi.util.NLS;

public class IntegerType
extends NumberType {
    private static final String INVALID_INTEGER = Messages.IntegerType_invalid_integer;

    protected String getReturnType() {
        return "int";
    }

    public boolean isValidValue(String value) {
        try {
            List validVals;
            Integer anInt = Integer.valueOf(value);
            this.exceedsMaxValue(anInt);
            this.lessThanMinValue(anInt);
            if (!(this.minFound || this.maxFound || (validVals = this.getCMValidValues()).isEmpty() || validVals.contains(value))) {
                this.addNewValidationMessage(Messages.IntegerType_invalid_member);
            }
            return this.getValidationMessages().isEmpty();
        }
        catch (NumberFormatException numberFormatException) {
            this.addNewValidationMessage(INVALID_INTEGER);
            return false;
        }
    }

    private void exceedsMaxValue(int anInt) {
        String strMax = this.getValidMaximumValue();
        if (strMax != null) {
            try {
                int max = Integer.valueOf(strMax);
                this.maxFound = true;
                if (anInt > max) {
                    this.addNewValidationMessage(NLS.bind((String)this.EXCEEDS_MAX, (Object)strMax));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void lessThanMinValue(int anInt) {
        String strMin = this.getValidMinimumValue();
        if (strMin != null) {
            try {
                int max = Integer.valueOf(strMin);
                this.minFound = true;
                if (anInt < max) {
                    this.addNewValidationMessage(NLS.bind((String)this.LESS_THAN_MIN, (Object)strMin));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

