/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues;

import java.util.List;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.internal.provisional.attributevalues.NumberType;
import org.eclipse.osgi.util.NLS;

public class DoubleType
extends NumberType {
    private static final String INVALID_DOUBLE = Messages.DoubleType_invalid_double;

    protected String getReturnType() {
        return "double";
    }

    public boolean isValidValue(String value) {
        try {
            List validVals;
            Double dbl = Double.valueOf(value);
            this.exceedsMaxValue(dbl);
            this.lessThanMinValue(dbl);
            if (!(this.minFound || this.maxFound || (validVals = this.getCMValidValues()).isEmpty() || validVals.contains(value))) {
                this.addNewValidationMessage(Messages.DoubleType_invalid_member);
            }
            return this.getValidationMessages().isEmpty();
        }
        catch (NumberFormatException numberFormatException) {
            this.addNewValidationMessage(INVALID_DOUBLE);
            return false;
        }
    }

    private void exceedsMaxValue(double dbl) {
        String strMax = this.getValidMaximumValue();
        if (strMax != null) {
            try {
                double max = Double.valueOf(strMax);
                this.maxFound = true;
                if (dbl > max) {
                    this.addNewValidationMessage(NLS.bind((String)this.EXCEEDS_MAX, (Object)strMax));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void lessThanMinValue(double dbl) {
        String strMin = this.getValidMinimumValue();
        if (strMin != null) {
            try {
                double max = Double.valueOf(strMin);
                this.minFound = true;
                if (dbl < max) {
                    this.addNewValidationMessage(NLS.bind((String)this.LESS_THAN_MIN, (Object)strMin));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

