/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.util;

import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;

public class ModelUtil {
    public static String getSuperType(Object key) {
        if (key == FacesConfigPackage.eINSTANCE.getActionListenerType()) {
            return "javax.faces.event.ActionListener";
        }
        if (key == FacesConfigPackage.eINSTANCE.getNavigationHandlerType()) {
            return "javax.faces.application.NavigationHandler";
        }
        if (key == FacesConfigPackage.eINSTANCE.getPropertyResolverType()) {
            return "javax.faces.el.PropertyResolver";
        }
        if (key == FacesConfigPackage.eINSTANCE.getStateManagerType()) {
            return "javax.faces.application.StateManager";
        }
        if (key == FacesConfigPackage.eINSTANCE.getVariableResolverType()) {
            return "javax.faces.el.VariableResolver";
        }
        if (key == FacesConfigPackage.eINSTANCE.getViewHandlerType()) {
            return "javax.faces.application.ViewHandler";
        }
        if (key == FacesConfigPackage.eINSTANCE.getApplicationFactoryType()) {
            return "javax.faces.application.ApplicationFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getFacesContextFactoryType()) {
            return "javax.faces.context.FacesContextFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getLifecycleFactoryType()) {
            return "javax.faces.lifecycle.LifecycleFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getRenderKitFactoryType()) {
            return "javax.faces.render.RenderKitFactory";
        }
        if (key == FacesConfigPackage.eINSTANCE.getPhaseListenerType()) {
            return "javax.faces.event.PhaseListener";
        }
        return null;
    }

    public static String escapeEntities(String str) {
        if (ModelUtil.isEmptyString(str)) {
            return "";
        }
        StringBuffer buffer = null;
        int i = 0;
        int n = str.length();
        while (i < n) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\r': {
                    entity = "&#xD;";
                    break;
                }
                case '\t': {
                    entity = "&#x9;";
                    break;
                }
                case '\n': {
                    entity = "&#xA;";
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity != null) {
                    buffer = new StringBuffer(str.length() + 20);
                    buffer.append(str.substring(0, i));
                    buffer.append(entity);
                }
            } else if (entity == null) {
                buffer.append(ch);
            } else {
                buffer.append(entity);
            }
            ++i;
        }
        return buffer == null ? str : buffer.toString();
    }

    public static String unEscapeEntities(String str) {
        if (ModelUtil.isEmptyString(str)) {
            return "";
        }
        String result = new String(str);
        result = result.replaceAll("&amp;", "&");
        result = result.replaceAll("&lt;", "<");
        result = result.replaceAll("&gt;", ">");
        result = result.replaceAll("&apos;", "'");
        result = result.replaceAll("&quot;", "\"");
        result = result.replaceAll("&#xD;", "\r");
        result = result.replaceAll("&#x9;", "\t");
        result = result.replaceAll("&#xA;", "\n");
        return result;
    }

    private static boolean isEmptyString(String value) {
        return value == null || value.length() == 0;
    }
}

